/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.HostProperties;

public class HostPropertiesUnmarshaller
implements Unmarshaller<HostProperties, StaxUnmarshallerContext> {
    private static HostPropertiesUnmarshaller INSTANCE;

    public HostProperties unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HostProperties.Builder hostProperties = HostProperties.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("cores", targetDepth)) {
                    hostProperties.cores(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    hostProperties.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sockets", targetDepth)) {
                    hostProperties.sockets(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("totalVCpus", targetDepth)) continue;
                hostProperties.totalVCpus(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HostProperties)hostProperties.build();
    }

    public static HostPropertiesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HostPropertiesUnmarshaller();
        }
        return INSTANCE;
    }
}

