/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest;
import software.amazon.awssdk.util.StringUtils;

public class DisassociateAddressRequestMarshaller
implements Marshaller<Request<DisassociateAddressRequest>, DisassociateAddressRequest> {
    public Request<DisassociateAddressRequest> marshall(DisassociateAddressRequest disassociateAddressRequest) {
        if (disassociateAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)disassociateAddressRequest, "EC2Client");
        request.addParameter("Action", "DisassociateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (disassociateAddressRequest.associationId() != null) {
            request.addParameter("AssociationId", StringUtils.fromString((String)disassociateAddressRequest.associationId()));
        }
        if (disassociateAddressRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString((String)disassociateAddressRequest.publicIp()));
        }
        return request;
    }
}

