/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVpnConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpnConnectionsRequest>, DescribeVpnConnectionsRequest> {
    public Request<DescribeVpnConnectionsRequest> marshall(DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        SdkInternalList describeVpnConnectionsRequestVpnConnectionIdsList;
        if (describeVpnConnectionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpnConnectionsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpnConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpnConnectionsRequestFiltersList = (SdkInternalList)describeVpnConnectionsRequest.filters();
        if (!describeVpnConnectionsRequestFiltersList.isEmpty() || !describeVpnConnectionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpnConnectionsRequestFiltersListValue : describeVpnConnectionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpnConnectionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpnConnectionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpnConnectionsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpnConnectionsRequestVpnConnectionIdsList = (SdkInternalList)describeVpnConnectionsRequest.vpnConnectionIds()).isEmpty() || !describeVpnConnectionsRequestVpnConnectionIdsList.isAutoConstruct()) {
            int vpnConnectionIdsListIndex = 1;
            for (String describeVpnConnectionsRequestVpnConnectionIdsListValue : describeVpnConnectionsRequestVpnConnectionIdsList) {
                if (describeVpnConnectionsRequestVpnConnectionIdsListValue != null) {
                    request.addParameter("VpnConnectionId." + vpnConnectionIdsListIndex, StringUtils.fromString((String)describeVpnConnectionsRequestVpnConnectionIdsListValue));
                }
                ++vpnConnectionIdsListIndex;
            }
        }
        return request;
    }
}

