/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVpcEndpointsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointsRequest>, DescribeVpcEndpointsRequest> {
    public Request<DescribeVpcEndpointsRequest> marshall(DescribeVpcEndpointsRequest describeVpcEndpointsRequest) {
        SdkInternalList describeVpcEndpointsRequestVpcEndpointIdsList;
        if (describeVpcEndpointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcEndpointsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcEndpoints");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpcEndpointsRequestFiltersList = (SdkInternalList)describeVpcEndpointsRequest.filters();
        if (!describeVpcEndpointsRequestFiltersList.isEmpty() || !describeVpcEndpointsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointsRequestFiltersListValue : describeVpcEndpointsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcEndpointsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcEndpointsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcEndpointsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVpcEndpointsRequest.maxResults()));
        }
        if (describeVpcEndpointsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVpcEndpointsRequest.nextToken()));
        }
        if (!(describeVpcEndpointsRequestVpcEndpointIdsList = (SdkInternalList)describeVpcEndpointsRequest.vpcEndpointIds()).isEmpty() || !describeVpcEndpointsRequestVpcEndpointIdsList.isAutoConstruct()) {
            int vpcEndpointIdsListIndex = 1;
            for (String describeVpcEndpointsRequestVpcEndpointIdsListValue : describeVpcEndpointsRequestVpcEndpointIdsList) {
                if (describeVpcEndpointsRequestVpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringUtils.fromString((String)describeVpcEndpointsRequestVpcEndpointIdsListValue));
                }
                ++vpcEndpointIdsListIndex;
            }
        }
        return request;
    }
}

