/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVolumesModificationsRequestMarshaller
implements Marshaller<Request<DescribeVolumesModificationsRequest>, DescribeVolumesModificationsRequest> {
    public Request<DescribeVolumesModificationsRequest> marshall(DescribeVolumesModificationsRequest describeVolumesModificationsRequest) {
        SdkInternalList describeVolumesModificationsRequestFiltersList;
        if (describeVolumesModificationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVolumesModificationsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVolumesModifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVolumesModificationsRequestVolumeIdsList = (SdkInternalList)describeVolumesModificationsRequest.volumeIds();
        if (!describeVolumesModificationsRequestVolumeIdsList.isEmpty() || !describeVolumesModificationsRequestVolumeIdsList.isAutoConstruct()) {
            int volumeIdsListIndex = 1;
            for (String describeVolumesModificationsRequestVolumeIdsListValue : describeVolumesModificationsRequestVolumeIdsList) {
                if (describeVolumesModificationsRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString((String)describeVolumesModificationsRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        if (!(describeVolumesModificationsRequestFiltersList = (SdkInternalList)describeVolumesModificationsRequest.filters()).isEmpty() || !describeVolumesModificationsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVolumesModificationsRequestFiltersListValue : describeVolumesModificationsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVolumesModificationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVolumesModificationsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVolumesModificationsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVolumesModificationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVolumesModificationsRequest.nextToken()));
        }
        if (describeVolumesModificationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVolumesModificationsRequest.maxResults()));
        }
        return request;
    }
}

