/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAddressesRequestMarshaller
implements Marshaller<Request<DescribeAddressesRequest>, DescribeAddressesRequest> {
    public Request<DescribeAddressesRequest> marshall(DescribeAddressesRequest describeAddressesRequest) {
        SdkInternalList describeAddressesRequestAllocationIdsList;
        SdkInternalList describeAddressesRequestPublicIpsList;
        if (describeAddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAddressesRequest, "EC2Client");
        request.addParameter("Action", "DescribeAddresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeAddressesRequestFiltersList = (SdkInternalList)describeAddressesRequest.filters();
        if (!describeAddressesRequestFiltersList.isEmpty() || !describeAddressesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeAddressesRequestFiltersListValue : describeAddressesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeAddressesRequestFiltersListValue).name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)((Filter)describeAddressesRequestFiltersListValue).name()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeAddressesRequestFiltersListValue).values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeAddressesRequestPublicIpsList = (SdkInternalList)describeAddressesRequest.publicIps()).isEmpty() || !describeAddressesRequestPublicIpsList.isAutoConstruct()) {
            int publicIpsListIndex = 1;
            for (String describeAddressesRequestPublicIpsListValue : describeAddressesRequestPublicIpsList) {
                if (describeAddressesRequestPublicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString((String)describeAddressesRequestPublicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        if (!(describeAddressesRequestAllocationIdsList = (SdkInternalList)describeAddressesRequest.allocationIds()).isEmpty() || !describeAddressesRequestAllocationIdsList.isAutoConstruct()) {
            int allocationIdsListIndex = 1;
            for (String describeAddressesRequestAllocationIdsListValue : describeAddressesRequestAllocationIdsList) {
                if (describeAddressesRequestAllocationIdsListValue != null) {
                    request.addParameter("AllocationId." + allocationIdsListIndex, StringUtils.fromString((String)describeAddressesRequestAllocationIdsListValue));
                }
                ++allocationIdsListIndex;
            }
        }
        return request;
    }
}

