/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class DeleteTagsRequestMarshaller
implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {
    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {
        SdkInternalList deleteTagsRequestTagsList;
        if (deleteTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteTagsRequest, "EC2Client");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList deleteTagsRequestResourcesList = (SdkInternalList)deleteTagsRequest.resources();
        if (!deleteTagsRequestResourcesList.isEmpty() || !deleteTagsRequestResourcesList.isAutoConstruct()) {
            int resourcesListIndex = 1;
            for (String deleteTagsRequestResourcesListValue : deleteTagsRequestResourcesList) {
                if (deleteTagsRequestResourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringUtils.fromString((String)deleteTagsRequestResourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (!(deleteTagsRequestTagsList = (SdkInternalList)deleteTagsRequest.tags()).isEmpty() || !deleteTagsRequestTagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag deleteTagsRequestTagsListValue : deleteTagsRequestTagsList) {
                if (deleteTagsRequestTagsListValue.key() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)deleteTagsRequestTagsListValue.key()));
                }
                if (deleteTagsRequestTagsListValue.value() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)deleteTagsRequestTagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

