/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteSnapshotRequestMarshaller
implements Marshaller<Request<DeleteSnapshotRequest>, DeleteSnapshotRequest> {
    public Request<DeleteSnapshotRequest> marshall(DeleteSnapshotRequest deleteSnapshotRequest) {
        if (deleteSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteSnapshotRequest, "EC2Client");
        request.addParameter("Action", "DeleteSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSnapshotRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)deleteSnapshotRequest.snapshotId()));
        }
        return request;
    }
}

