/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateTagsRequestMarshaller
implements Marshaller<Request<CreateTagsRequest>, CreateTagsRequest> {
    public Request<CreateTagsRequest> marshall(CreateTagsRequest createTagsRequest) {
        SdkInternalList createTagsRequestTagsList;
        if (createTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTagsRequest, "EC2Client");
        request.addParameter("Action", "CreateTags");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createTagsRequestResourcesList = (SdkInternalList)createTagsRequest.resources();
        if (!createTagsRequestResourcesList.isEmpty() || !createTagsRequestResourcesList.isAutoConstruct()) {
            int resourcesListIndex = 1;
            for (String createTagsRequestResourcesListValue : createTagsRequestResourcesList) {
                if (createTagsRequestResourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringUtils.fromString((String)createTagsRequestResourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (!(createTagsRequestTagsList = (SdkInternalList)createTagsRequest.tags()).isEmpty() || !createTagsRequestTagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag createTagsRequestTagsListValue : createTagsRequestTagsList) {
                if (createTagsRequestTagsListValue.key() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)createTagsRequestTagsListValue.key()));
                }
                if (createTagsRequestTagsListValue.value() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)createTagsRequestTagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

