/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;
import software.amazon.awssdk.util.StringUtils;

public class CreateDhcpOptionsRequestMarshaller
implements Marshaller<Request<CreateDhcpOptionsRequest>, CreateDhcpOptionsRequest> {
    public Request<CreateDhcpOptionsRequest> marshall(CreateDhcpOptionsRequest createDhcpOptionsRequest) {
        if (createDhcpOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDhcpOptionsRequest, "EC2Client");
        request.addParameter("Action", "CreateDhcpOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createDhcpOptionsRequestDhcpConfigurationsList = (SdkInternalList)createDhcpOptionsRequest.dhcpConfigurations();
        if (!createDhcpOptionsRequestDhcpConfigurationsList.isEmpty() || !createDhcpOptionsRequestDhcpConfigurationsList.isAutoConstruct()) {
            int dhcpConfigurationsListIndex = 1;
            for (DhcpConfiguration createDhcpOptionsRequestDhcpConfigurationsListValue : createDhcpOptionsRequestDhcpConfigurationsList) {
                SdkInternalList dhcpConfigurationValuesList;
                if (createDhcpOptionsRequestDhcpConfigurationsListValue.key() != null) {
                    request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Key", StringUtils.fromString((String)createDhcpOptionsRequestDhcpConfigurationsListValue.key()));
                }
                if (!(dhcpConfigurationValuesList = (SdkInternalList)createDhcpOptionsRequestDhcpConfigurationsListValue.values()).isEmpty() || !dhcpConfigurationValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String dhcpConfigurationValuesListValue : dhcpConfigurationValuesList) {
                        if (dhcpConfigurationValuesListValue != null) {
                            request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)dhcpConfigurationValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++dhcpConfigurationsListIndex;
            }
        }
        return request;
    }
}

