/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import software.amazon.awssdk.util.StringUtils;

public class AttachVolumeRequestMarshaller
implements Marshaller<Request<AttachVolumeRequest>, AttachVolumeRequest> {
    public Request<AttachVolumeRequest> marshall(AttachVolumeRequest attachVolumeRequest) {
        if (attachVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachVolumeRequest, "EC2Client");
        request.addParameter("Action", "AttachVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachVolumeRequest.device() != null) {
            request.addParameter("Device", StringUtils.fromString((String)attachVolumeRequest.device()));
        }
        if (attachVolumeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)attachVolumeRequest.instanceId()));
        }
        if (attachVolumeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)attachVolumeRequest.volumeId()));
        }
        return request;
    }
}

