/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.AssociateAddressRequest;
import software.amazon.awssdk.util.StringUtils;

public class AssociateAddressRequestMarshaller
implements Marshaller<Request<AssociateAddressRequest>, AssociateAddressRequest> {
    public Request<AssociateAddressRequest> marshall(AssociateAddressRequest associateAddressRequest) {
        if (associateAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)associateAddressRequest, "EC2Client");
        request.addParameter("Action", "AssociateAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (associateAddressRequest.allocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString((String)associateAddressRequest.allocationId()));
        }
        if (associateAddressRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)associateAddressRequest.instanceId()));
        }
        if (associateAddressRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString((String)associateAddressRequest.publicIp()));
        }
        if (associateAddressRequest.allowReassociation() != null) {
            request.addParameter("AllowReassociation", StringUtils.fromBoolean((Boolean)associateAddressRequest.allowReassociation()));
        }
        if (associateAddressRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)associateAddressRequest.networkInterfaceId()));
        }
        if (associateAddressRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)associateAddressRequest.privateIpAddress()));
        }
        return request;
    }
}

