/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduledInstancesBlockDeviceMapping
implements ToCopyableBuilder<Builder, ScheduledInstancesBlockDeviceMapping> {
    private final String deviceName;
    private final ScheduledInstancesEbs ebs;
    private final String noDevice;
    private final String virtualName;

    private ScheduledInstancesBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public ScheduledInstancesEbs ebs() {
        return this.ebs;
    }

    public String noDevice() {
        return this.noDevice;
    }

    public String virtualName() {
        return this.virtualName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deviceName() == null ? 0 : this.deviceName().hashCode());
        hashCode = 31 * hashCode + (this.ebs() == null ? 0 : this.ebs().hashCode());
        hashCode = 31 * hashCode + (this.noDevice() == null ? 0 : this.noDevice().hashCode());
        hashCode = 31 * hashCode + (this.virtualName() == null ? 0 : this.virtualName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesBlockDeviceMapping)) {
            return false;
        }
        ScheduledInstancesBlockDeviceMapping other = (ScheduledInstancesBlockDeviceMapping)obj;
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        if (other.ebs() != null && !other.ebs().equals(this.ebs())) {
            return false;
        }
        if (other.noDevice() == null ^ this.noDevice() == null) {
            return false;
        }
        if (other.noDevice() != null && !other.noDevice().equals(this.noDevice())) {
            return false;
        }
        if (other.virtualName() == null ^ this.virtualName() == null) {
            return false;
        }
        return other.virtualName() == null || other.virtualName().equals(this.virtualName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deviceName() != null) {
            sb.append("DeviceName: ").append(this.deviceName()).append(",");
        }
        if (this.ebs() != null) {
            sb.append("Ebs: ").append(this.ebs()).append(",");
        }
        if (this.noDevice() != null) {
            sb.append("NoDevice: ").append(this.noDevice()).append(",");
        }
        if (this.virtualName() != null) {
            sb.append("VirtualName: ").append(this.virtualName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private ScheduledInstancesEbs ebs;
        private String noDevice;
        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesBlockDeviceMapping model) {
            this.setDeviceName(model.deviceName);
            this.setEbs(model.ebs);
            this.setNoDevice(model.noDevice);
            this.setVirtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final ScheduledInstancesEbs getEbs() {
            return this.ebs;
        }

        @Override
        public final Builder ebs(ScheduledInstancesEbs ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(ScheduledInstancesEbs ebs) {
            this.ebs = ebs;
        }

        public final String getNoDevice() {
            return this.noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public ScheduledInstancesBlockDeviceMapping build() {
            return new ScheduledInstancesBlockDeviceMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledInstancesBlockDeviceMapping> {
        public Builder deviceName(String var1);

        public Builder ebs(ScheduledInstancesEbs var1);

        public Builder noDevice(String var1);

        public Builder virtualName(String var1);
    }
}

