/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.PlacementGroupState;
import software.amazon.awssdk.services.ec2.model.PlacementStrategy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PlacementGroup
implements ToCopyableBuilder<Builder, PlacementGroup> {
    private final String groupName;
    private final String state;
    private final String strategy;

    private PlacementGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.state = builder.state;
        this.strategy = builder.strategy;
    }

    public String groupName() {
        return this.groupName;
    }

    public String state() {
        return this.state;
    }

    public String strategy() {
        return this.strategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.strategy() == null ? 0 : this.strategy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroup)) {
            return false;
        }
        PlacementGroup other = (PlacementGroup)obj;
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.strategy() == null ^ this.strategy() == null) {
            return false;
        }
        return other.strategy() == null || other.strategy().equals(this.strategy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.strategy() != null) {
            sb.append("Strategy: ").append(this.strategy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String state;
        private String strategy;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroup model) {
            this.setGroupName(model.groupName);
            this.setState(model.state);
            this.setStrategy(model.strategy);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PlacementGroupState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(PlacementGroupState state) {
            this.state(state.toString());
        }

        public final String getStrategy() {
            return this.strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
            return this;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        public final void setStrategy(PlacementStrategy strategy) {
            this.strategy(strategy.toString());
        }

        public PlacementGroup build() {
            return new PlacementGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PlacementGroup> {
        public Builder groupName(String var1);

        public Builder state(String var1);

        public Builder state(PlacementGroupState var1);

        public Builder strategy(String var1);

        public Builder strategy(PlacementStrategy var1);
    }
}

