/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInterfacePrivateIpAddress
implements ToCopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
    private final NetworkInterfaceAssociation association;
    private final Boolean primary;
    private final String privateDnsName;
    private final String privateIpAddress;

    private NetworkInterfacePrivateIpAddress(BuilderImpl builder) {
        this.association = builder.association;
        this.primary = builder.primary;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public NetworkInterfaceAssociation association() {
        return this.association;
    }

    public Boolean primary() {
        return this.primary;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.association() == null ? 0 : this.association().hashCode());
        hashCode = 31 * hashCode + (this.primary() == null ? 0 : this.primary().hashCode());
        hashCode = 31 * hashCode + (this.privateDnsName() == null ? 0 : this.privateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePrivateIpAddress)) {
            return false;
        }
        NetworkInterfacePrivateIpAddress other = (NetworkInterfacePrivateIpAddress)obj;
        if (other.association() == null ^ this.association() == null) {
            return false;
        }
        if (other.association() != null && !other.association().equals(this.association())) {
            return false;
        }
        if (other.primary() == null ^ this.primary() == null) {
            return false;
        }
        if (other.primary() != null && !other.primary().equals(this.primary())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        return other.privateIpAddress() == null || other.privateIpAddress().equals(this.privateIpAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.association() != null) {
            sb.append("Association: ").append(this.association()).append(",");
        }
        if (this.primary() != null) {
            sb.append("Primary: ").append(this.primary()).append(",");
        }
        if (this.privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.privateDnsName()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private NetworkInterfaceAssociation association;
        private Boolean primary;
        private String privateDnsName;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePrivateIpAddress model) {
            this.setAssociation(model.association);
            this.setPrimary(model.primary);
            this.setPrivateDnsName(model.privateDnsName);
            this.setPrivateIpAddress(model.privateIpAddress);
        }

        public final NetworkInterfaceAssociation getAssociation() {
            return this.association;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation association) {
            this.association = association;
        }

        public final Boolean getPrimary() {
            return this.primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public NetworkInterfacePrivateIpAddress build() {
            return new NetworkInterfacePrivateIpAddress(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
        public Builder association(NetworkInterfaceAssociation var1);

        public Builder primary(Boolean var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);
    }
}

