/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyNetworkInterfaceAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyNetworkInterfaceAttributeRequest> {
    private final NetworkInterfaceAttachmentChanges attachment;
    private final String description;
    private final List<String> groups;
    private final String networkInterfaceId;
    private final Boolean sourceDestCheck;

    private ModifyNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    public NetworkInterfaceAttachmentChanges attachment() {
        return this.attachment;
    }

    public String description() {
        return this.description;
    }

    public List<String> groups() {
        return this.groups;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachment() == null ? 0 : this.attachment().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.sourceDestCheck() == null ? 0 : this.sourceDestCheck().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ModifyNetworkInterfaceAttributeRequest other = (ModifyNetworkInterfaceAttributeRequest)((Object)obj);
        if (other.attachment() == null ^ this.attachment() == null) {
            return false;
        }
        if (other.attachment() != null && !other.attachment().equals(this.attachment())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        return other.sourceDestCheck() == null || other.sourceDestCheck().equals(this.sourceDestCheck());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachment() != null) {
            sb.append("Attachment: ").append(this.attachment()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.sourceDestCheck()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private NetworkInterfaceAttachmentChanges attachment;
        private String description;
        private List<String> groups = new SdkInternalList();
        private String networkInterfaceId;
        private Boolean sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyNetworkInterfaceAttributeRequest model) {
            this.setAttachment(model.attachment);
            this.setDescription(model.description);
            this.setGroups(model.groups);
            this.setNetworkInterfaceId(model.networkInterfaceId);
            this.setSourceDestCheck(model.sourceDestCheck);
        }

        public final NetworkInterfaceAttachmentChanges getAttachment() {
            return this.attachment;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachmentChanges attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachmentChanges attachment) {
            this.attachment = attachment;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            if (this.groups == null) {
                this.groups = new SdkInternalList(groups.length);
            }
            for (String e : groups) {
                this.groups.add(e);
            }
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(String ... groups) {
            if (this.groups == null) {
                this.groups = new SdkInternalList(groups.length);
            }
            for (String e : groups) {
                this.groups.add(e);
            }
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public ModifyNetworkInterfaceAttributeRequest build() {
            return new ModifyNetworkInterfaceAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyNetworkInterfaceAttributeRequest> {
        public Builder attachment(NetworkInterfaceAttachmentChanges var1);

        public Builder description(String var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder sourceDestCheck(Boolean var1);
    }
}

