/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAttribute
implements ToCopyableBuilder<Builder, InstanceAttribute> {
    private final List<GroupIdentifier> groups;
    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private final Boolean disableApiTermination;
    private final Boolean enaSupport;
    private final Boolean ebsOptimized;
    private final String instanceId;
    private final String instanceInitiatedShutdownBehavior;
    private final String instanceType;
    private final String kernelId;
    private final List<ProductCode> productCodes;
    private final String ramdiskId;
    private final String rootDeviceName;
    private final Boolean sourceDestCheck;
    private final String sriovNetSupport;
    private final String userData;

    private InstanceAttribute(BuilderImpl builder) {
        this.groups = builder.groups;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.enaSupport = builder.enaSupport;
        this.ebsOptimized = builder.ebsOptimized;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public Boolean enaSupport() {
        return this.enaSupport;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String rootDeviceName() {
        return this.rootDeviceName;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public String userData() {
        return this.userData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.disableApiTermination() == null ? 0 : this.disableApiTermination().hashCode());
        hashCode = 31 * hashCode + (this.enaSupport() == null ? 0 : this.enaSupport().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.instanceInitiatedShutdownBehavior() == null ? 0 : this.instanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.productCodes() == null ? 0 : this.productCodes().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceName() == null ? 0 : this.rootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.sourceDestCheck() == null ? 0 : this.sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.sriovNetSupport() == null ? 0 : this.sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAttribute)) {
            return false;
        }
        InstanceAttribute other = (InstanceAttribute)obj;
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.disableApiTermination() == null ^ this.disableApiTermination() == null) {
            return false;
        }
        if (other.disableApiTermination() != null && !other.disableApiTermination().equals(this.disableApiTermination())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() == null ^ this.instanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() != null && !other.instanceInitiatedShutdownBehavior().equals(this.instanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.rootDeviceName() == null ^ this.rootDeviceName() == null) {
            return false;
        }
        if (other.rootDeviceName() != null && !other.rootDeviceName().equals(this.rootDeviceName())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        return other.userData() == null || other.userData().equals(this.userData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.disableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(this.disableApiTermination()).append(",");
        }
        if (this.enaSupport() != null) {
            sb.append("EnaSupport: ").append(this.enaSupport()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.instanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.instanceInitiatedShutdownBehavior()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(this.rootDeviceName()).append(",");
        }
        if (this.sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.sourceDestCheck()).append(",");
        }
        if (this.sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.sriovNetSupport()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<GroupIdentifier> groups = new SdkInternalList();
        private List<InstanceBlockDeviceMapping> blockDeviceMappings = new SdkInternalList();
        private Boolean disableApiTermination;
        private Boolean enaSupport;
        private Boolean ebsOptimized;
        private String instanceId;
        private String instanceInitiatedShutdownBehavior;
        private String instanceType;
        private String kernelId;
        private List<ProductCode> productCodes = new SdkInternalList();
        private String ramdiskId;
        private String rootDeviceName;
        private Boolean sourceDestCheck;
        private String sriovNetSupport;
        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAttribute model) {
            this.setGroups(model.groups);
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setDisableApiTermination(model.disableApiTermination);
            this.setEnaSupport(model.enaSupport);
            this.setEbsOptimized(model.ebsOptimized);
            this.setInstanceId(model.instanceId);
            this.setInstanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.setInstanceType(model.instanceType);
            this.setKernelId(model.kernelId);
            this.setProductCodes(model.productCodes);
            this.setRamdiskId(model.ramdiskId);
            this.setRootDeviceName(model.rootDeviceName);
            this.setSourceDestCheck(model.sourceDestCheck);
            this.setSriovNetSupport(model.sriovNetSupport);
            this.setUserData(model.userData);
        }

        public final Collection<GroupIdentifier> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            if (this.groups == null) {
                this.groups = new SdkInternalList(groups.length);
            }
            for (GroupIdentifier e : groups) {
                this.groups.add(e);
            }
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(GroupIdentifier ... groups) {
            if (this.groups == null) {
                this.groups = new SdkInternalList(groups.length);
            }
            for (GroupIdentifier e : groups) {
                this.groups.add(e);
            }
        }

        public final Collection<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
            if (this.blockDeviceMappings == null) {
                this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings.length);
            }
            for (InstanceBlockDeviceMapping e : blockDeviceMappings) {
                this.blockDeviceMappings.add(e);
            }
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
            if (this.blockDeviceMappings == null) {
                this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings.length);
            }
            for (InstanceBlockDeviceMapping e : blockDeviceMappings) {
                this.blockDeviceMappings.add(e);
            }
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Collection<ProductCode> getProductCodes() {
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            if (this.productCodes == null) {
                this.productCodes = new SdkInternalList(productCodes.length);
            }
            for (ProductCode e : productCodes) {
                this.productCodes.add(e);
            }
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        @SafeVarargs
        public final void setProductCodes(ProductCode ... productCodes) {
            if (this.productCodes == null) {
                this.productCodes = new SdkInternalList(productCodes.length);
            }
            for (ProductCode e : productCodes) {
                this.productCodes.add(e);
            }
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public InstanceAttribute build() {
            return new InstanceAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAttribute> {
        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMapping ... var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder enaSupport(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder instanceId(String var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceType(String var1);

        public Builder kernelId(String var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder ramdiskId(String var1);

        public Builder rootDeviceName(String var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder sriovNetSupport(String var1);

        public Builder userData(String var1);
    }
}

