/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.DiskImage;
import software.amazon.awssdk.services.ec2.model.DiskImageListCopier;
import software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportInstanceRequest> {
    private final String description;
    private final List<DiskImage> diskImages;
    private final ImportInstanceLaunchSpecification launchSpecification;
    private final String platform;

    private ImportInstanceRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.diskImages = builder.diskImages;
        this.launchSpecification = builder.launchSpecification;
        this.platform = builder.platform;
    }

    public String description() {
        return this.description;
    }

    public List<DiskImage> diskImages() {
        return this.diskImages;
    }

    public ImportInstanceLaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public String platform() {
        return this.platform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.diskImages() == null ? 0 : this.diskImages().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecification() == null ? 0 : this.launchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceRequest)) {
            return false;
        }
        ImportInstanceRequest other = (ImportInstanceRequest)((Object)obj);
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.diskImages() == null ^ this.diskImages() == null) {
            return false;
        }
        if (other.diskImages() != null && !other.diskImages().equals(this.diskImages())) {
            return false;
        }
        if (other.launchSpecification() == null ^ this.launchSpecification() == null) {
            return false;
        }
        if (other.launchSpecification() != null && !other.launchSpecification().equals(this.launchSpecification())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        return other.platform() == null || other.platform().equals(this.platform());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.diskImages() != null) {
            sb.append("DiskImages: ").append(this.diskImages()).append(",");
        }
        if (this.launchSpecification() != null) {
            sb.append("LaunchSpecification: ").append(this.launchSpecification()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private List<DiskImage> diskImages = new SdkInternalList();
        private ImportInstanceLaunchSpecification launchSpecification;
        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceRequest model) {
            this.setDescription(model.description);
            this.setDiskImages(model.diskImages);
            this.setLaunchSpecification(model.launchSpecification);
            this.setPlatform(model.platform);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DiskImage> getDiskImages() {
            return this.diskImages;
        }

        @Override
        public final Builder diskImages(Collection<DiskImage> diskImages) {
            this.diskImages = DiskImageListCopier.copy(diskImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskImages(DiskImage ... diskImages) {
            if (this.diskImages == null) {
                this.diskImages = new SdkInternalList(diskImages.length);
            }
            for (DiskImage e : diskImages) {
                this.diskImages.add(e);
            }
            return this;
        }

        public final void setDiskImages(Collection<DiskImage> diskImages) {
            this.diskImages = DiskImageListCopier.copy(diskImages);
        }

        @SafeVarargs
        public final void setDiskImages(DiskImage ... diskImages) {
            if (this.diskImages == null) {
                this.diskImages = new SdkInternalList(diskImages.length);
            }
            for (DiskImage e : diskImages) {
                this.diskImages.add(e);
            }
        }

        public final ImportInstanceLaunchSpecification getLaunchSpecification() {
            return this.launchSpecification;
        }

        @Override
        public final Builder launchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(ImportInstanceLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(PlatformValues platform) {
            this.platform(platform.toString());
        }

        public ImportInstanceRequest build() {
            return new ImportInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportInstanceRequest> {
        public Builder description(String var1);

        public Builder diskImages(Collection<DiskImage> var1);

        public Builder diskImages(DiskImage ... var1);

        public Builder launchSpecification(ImportInstanceLaunchSpecification var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);
    }
}

