/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.UserData;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportInstanceLaunchSpecification
implements ToCopyableBuilder<Builder, ImportInstanceLaunchSpecification> {
    private final String additionalInfo;
    private final String architecture;
    private final List<String> groupIds;
    private final List<String> groupNames;
    private final String instanceInitiatedShutdownBehavior;
    private final String instanceType;
    private final Boolean monitoring;
    private final Placement placement;
    private final String privateIpAddress;
    private final String subnetId;
    private final UserData userData;

    private ImportInstanceLaunchSpecification(BuilderImpl builder) {
        this.additionalInfo = builder.additionalInfo;
        this.architecture = builder.architecture;
        this.groupIds = builder.groupIds;
        this.groupNames = builder.groupNames;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.privateIpAddress = builder.privateIpAddress;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public String architecture() {
        return this.architecture;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public String instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Boolean monitoring() {
        return this.monitoring;
    }

    public Placement placement() {
        return this.placement;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public UserData userData() {
        return this.userData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.additionalInfo() == null ? 0 : this.additionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.architecture() == null ? 0 : this.architecture().hashCode());
        hashCode = 31 * hashCode + (this.groupIds() == null ? 0 : this.groupIds().hashCode());
        hashCode = 31 * hashCode + (this.groupNames() == null ? 0 : this.groupNames().hashCode());
        hashCode = 31 * hashCode + (this.instanceInitiatedShutdownBehavior() == null ? 0 : this.instanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.monitoring() == null ? 0 : this.monitoring().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceLaunchSpecification)) {
            return false;
        }
        ImportInstanceLaunchSpecification other = (ImportInstanceLaunchSpecification)obj;
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        if (other.additionalInfo() != null && !other.additionalInfo().equals(this.additionalInfo())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.groupIds() == null ^ this.groupIds() == null) {
            return false;
        }
        if (other.groupIds() != null && !other.groupIds().equals(this.groupIds())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        if (other.groupNames() != null && !other.groupNames().equals(this.groupNames())) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() == null ^ this.instanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() != null && !other.instanceInitiatedShutdownBehavior().equals(this.instanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        return other.userData() == null || other.userData().equals(this.userData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        if (this.architecture() != null) {
            sb.append("Architecture: ").append(this.architecture()).append(",");
        }
        if (this.groupIds() != null) {
            sb.append("GroupIds: ").append(this.groupIds()).append(",");
        }
        if (this.groupNames() != null) {
            sb.append("GroupNames: ").append(this.groupNames()).append(",");
        }
        if (this.instanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.instanceInitiatedShutdownBehavior()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.monitoring() != null) {
            sb.append("Monitoring: ").append(this.monitoring()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String additionalInfo;
        private String architecture;
        private List<String> groupIds = new SdkInternalList();
        private List<String> groupNames = new SdkInternalList();
        private String instanceInitiatedShutdownBehavior;
        private String instanceType;
        private Boolean monitoring;
        private Placement placement;
        private String privateIpAddress;
        private String subnetId;
        private UserData userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceLaunchSpecification model) {
            this.setAdditionalInfo(model.additionalInfo);
            this.setArchitecture(model.architecture);
            this.setGroupIds(model.groupIds);
            this.setGroupNames(model.groupNames);
            this.setInstanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.setInstanceType(model.instanceType);
            this.setMonitoring(model.monitoring);
            this.setPlacement(model.placement);
            this.setPrivateIpAddress(model.privateIpAddress);
            this.setSubnetId(model.subnetId);
            this.setUserData(model.userData);
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final void setArchitecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
        }

        public final Collection<String> getGroupIds() {
            return this.groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String ... groupIds) {
            if (this.groupIds == null) {
                this.groupIds = new SdkInternalList(groupIds.length);
            }
            for (String e : groupIds) {
                this.groupIds.add(e);
            }
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
        }

        @SafeVarargs
        public final void setGroupIds(String ... groupIds) {
            if (this.groupIds == null) {
                this.groupIds = new SdkInternalList(groupIds.length);
            }
            for (String e : groupIds) {
                this.groupIds.add(e);
            }
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            if (this.groupNames == null) {
                this.groupNames = new SdkInternalList(groupNames.length);
            }
            for (String e : groupNames) {
                this.groupNames.add(e);
            }
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
        }

        @SafeVarargs
        public final void setGroupNames(String ... groupNames) {
            if (this.groupNames == null) {
                this.groupNames = new SdkInternalList(groupNames.length);
            }
            for (String e : groupNames) {
                this.groupNames.add(e);
            }
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final void setInstanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final Boolean getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final Builder monitoring(Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        public final Placement getPlacement() {
            return this.placement;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement placement) {
            this.placement = placement;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final UserData getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(UserData userData) {
            this.userData = userData;
        }

        public ImportInstanceLaunchSpecification build() {
            return new ImportInstanceLaunchSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportInstanceLaunchSpecification> {
        public Builder additionalInfo(String var1);

        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder groupIds(Collection<String> var1);

        public Builder groupIds(String ... var1);

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder monitoring(Boolean var1);

        public Builder placement(Placement var1);

        public Builder privateIpAddress(String var1);

        public Builder subnetId(String var1);

        public Builder userData(UserData var1);
    }
}

