/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.PaymentOption;
import software.amazon.awssdk.services.ec2.model.ReservationState;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HostReservation
implements ToCopyableBuilder<Builder, HostReservation> {
    private final Integer count;
    private final String currencyCode;
    private final Integer duration;
    private final Date end;
    private final List<String> hostIdSet;
    private final String hostReservationId;
    private final String hourlyPrice;
    private final String instanceFamily;
    private final String offeringId;
    private final String paymentOption;
    private final Date start;
    private final String state;
    private final String upfrontPrice;

    private HostReservation(BuilderImpl builder) {
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.end = builder.end;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.start = builder.start;
        this.state = builder.state;
        this.upfrontPrice = builder.upfrontPrice;
    }

    public Integer count() {
        return this.count;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public Integer duration() {
        return this.duration;
    }

    public Date end() {
        return this.end;
    }

    public List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public String hostReservationId() {
        return this.hostReservationId;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public String instanceFamily() {
        return this.instanceFamily;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public String paymentOption() {
        return this.paymentOption;
    }

    public Date start() {
        return this.start;
    }

    public String state() {
        return this.state;
    }

    public String upfrontPrice() {
        return this.upfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.end() == null ? 0 : this.end().hashCode());
        hashCode = 31 * hashCode + (this.hostIdSet() == null ? 0 : this.hostIdSet().hashCode());
        hashCode = 31 * hashCode + (this.hostReservationId() == null ? 0 : this.hostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.hourlyPrice() == null ? 0 : this.hourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceFamily() == null ? 0 : this.instanceFamily().hashCode());
        hashCode = 31 * hashCode + (this.offeringId() == null ? 0 : this.offeringId().hashCode());
        hashCode = 31 * hashCode + (this.paymentOption() == null ? 0 : this.paymentOption().hashCode());
        hashCode = 31 * hashCode + (this.start() == null ? 0 : this.start().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.upfrontPrice() == null ? 0 : this.upfrontPrice().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostReservation)) {
            return false;
        }
        HostReservation other = (HostReservation)obj;
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        if (other.hostIdSet() == null ^ this.hostIdSet() == null) {
            return false;
        }
        if (other.hostIdSet() != null && !other.hostIdSet().equals(this.hostIdSet())) {
            return false;
        }
        if (other.hostReservationId() == null ^ this.hostReservationId() == null) {
            return false;
        }
        if (other.hostReservationId() != null && !other.hostReservationId().equals(this.hostReservationId())) {
            return false;
        }
        if (other.hourlyPrice() == null ^ this.hourlyPrice() == null) {
            return false;
        }
        if (other.hourlyPrice() != null && !other.hourlyPrice().equals(this.hourlyPrice())) {
            return false;
        }
        if (other.instanceFamily() == null ^ this.instanceFamily() == null) {
            return false;
        }
        if (other.instanceFamily() != null && !other.instanceFamily().equals(this.instanceFamily())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        if (other.offeringId() != null && !other.offeringId().equals(this.offeringId())) {
            return false;
        }
        if (other.paymentOption() == null ^ this.paymentOption() == null) {
            return false;
        }
        if (other.paymentOption() != null && !other.paymentOption().equals(this.paymentOption())) {
            return false;
        }
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.upfrontPrice() == null ^ this.upfrontPrice() == null) {
            return false;
        }
        return other.upfrontPrice() == null || other.upfrontPrice().equals(this.upfrontPrice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.end() != null) {
            sb.append("End: ").append(this.end()).append(",");
        }
        if (this.hostIdSet() != null) {
            sb.append("HostIdSet: ").append(this.hostIdSet()).append(",");
        }
        if (this.hostReservationId() != null) {
            sb.append("HostReservationId: ").append(this.hostReservationId()).append(",");
        }
        if (this.hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(this.hourlyPrice()).append(",");
        }
        if (this.instanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.instanceFamily()).append(",");
        }
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        if (this.paymentOption() != null) {
            sb.append("PaymentOption: ").append(this.paymentOption()).append(",");
        }
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.upfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(this.upfrontPrice()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer count;
        private String currencyCode;
        private Integer duration;
        private Date end;
        private List<String> hostIdSet = new SdkInternalList();
        private String hostReservationId;
        private String hourlyPrice;
        private String instanceFamily;
        private String offeringId;
        private String paymentOption;
        private Date start;
        private String state;
        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HostReservation model) {
            this.setCount(model.count);
            this.setCurrencyCode(model.currencyCode);
            this.setDuration(model.duration);
            this.setEnd(model.end);
            this.setHostIdSet(model.hostIdSet);
            this.setHostReservationId(model.hostReservationId);
            this.setHourlyPrice(model.hourlyPrice);
            this.setInstanceFamily(model.instanceFamily);
            this.setOfferingId(model.offeringId);
            this.setPaymentOption(model.paymentOption);
            this.setStart(model.start);
            this.setState(model.state);
            this.setUpfrontPrice(model.upfrontPrice);
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final void setCurrencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Date getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Date end) {
            this.end = StandardMemberCopier.copy((Date)end);
            return this;
        }

        public final void setEnd(Date end) {
            this.end = StandardMemberCopier.copy((Date)end);
        }

        public final Collection<String> getHostIdSet() {
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            if (this.hostIdSet == null) {
                this.hostIdSet = new SdkInternalList(hostIdSet.length);
            }
            for (String e : hostIdSet) {
                this.hostIdSet.add(e);
            }
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        @SafeVarargs
        public final void setHostIdSet(String ... hostIdSet) {
            if (this.hostIdSet == null) {
                this.hostIdSet = new SdkInternalList(hostIdSet.length);
            }
            for (String e : hostIdSet) {
                this.hostIdSet.add(e);
            }
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final void setPaymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
        }

        public final Date getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Date start) {
            this.start = StandardMemberCopier.copy((Date)start);
            return this;
        }

        public final void setStart(Date start) {
            this.start = StandardMemberCopier.copy((Date)start);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(ReservationState state) {
            this.state(state.toString());
        }

        public final String getUpfrontPrice() {
            return this.upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        public HostReservation build() {
            return new HostReservation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HostReservation> {
        public Builder count(Integer var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder duration(Integer var1);

        public Builder end(Date var1);

        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder hostReservationId(String var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceFamily(String var1);

        public Builder offeringId(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder start(Date var1);

        public Builder state(String var1);

        public Builder state(ReservationState var1);

        public Builder upfrontPrice(String var1);
    }
}

