/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.Purchase;
import software.amazon.awssdk.services.ec2.model.PurchaseSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHostReservationPurchasePreviewResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetHostReservationPurchasePreviewResponse> {
    private final String currencyCode;
    private final List<Purchase> purchase;
    private final String totalHourlyPrice;
    private final String totalUpfrontPrice;

    private GetHostReservationPurchasePreviewResponse(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public List<Purchase> purchase() {
        return this.purchase;
    }

    public String totalHourlyPrice() {
        return this.totalHourlyPrice;
    }

    public String totalUpfrontPrice() {
        return this.totalUpfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.purchase() == null ? 0 : this.purchase().hashCode());
        hashCode = 31 * hashCode + (this.totalHourlyPrice() == null ? 0 : this.totalHourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.totalUpfrontPrice() == null ? 0 : this.totalUpfrontPrice().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewResponse)) {
            return false;
        }
        GetHostReservationPurchasePreviewResponse other = (GetHostReservationPurchasePreviewResponse)((Object)obj);
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.purchase() == null ^ this.purchase() == null) {
            return false;
        }
        if (other.purchase() != null && !other.purchase().equals(this.purchase())) {
            return false;
        }
        if (other.totalHourlyPrice() == null ^ this.totalHourlyPrice() == null) {
            return false;
        }
        if (other.totalHourlyPrice() != null && !other.totalHourlyPrice().equals(this.totalHourlyPrice())) {
            return false;
        }
        if (other.totalUpfrontPrice() == null ^ this.totalUpfrontPrice() == null) {
            return false;
        }
        return other.totalUpfrontPrice() == null || other.totalUpfrontPrice().equals(this.totalUpfrontPrice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.purchase() != null) {
            sb.append("Purchase: ").append(this.purchase()).append(",");
        }
        if (this.totalHourlyPrice() != null) {
            sb.append("TotalHourlyPrice: ").append(this.totalHourlyPrice()).append(",");
        }
        if (this.totalUpfrontPrice() != null) {
            sb.append("TotalUpfrontPrice: ").append(this.totalUpfrontPrice()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private List<Purchase> purchase = new SdkInternalList();
        private String totalHourlyPrice;
        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewResponse model) {
            this.setCurrencyCode(model.currencyCode);
            this.setPurchase(model.purchase);
            this.setTotalHourlyPrice(model.totalHourlyPrice);
            this.setTotalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final void setCurrencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
        }

        public final Collection<Purchase> getPurchase() {
            return this.purchase;
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase ... purchase) {
            if (this.purchase == null) {
                this.purchase = new SdkInternalList(purchase.length);
            }
            for (Purchase e : purchase) {
                this.purchase.add(e);
            }
            return this;
        }

        public final void setPurchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
        }

        @SafeVarargs
        public final void setPurchase(Purchase ... purchase) {
            if (this.purchase == null) {
                this.purchase = new SdkInternalList(purchase.length);
            }
            for (Purchase e : purchase) {
                this.purchase.add(e);
            }
        }

        public final String getTotalHourlyPrice() {
            return this.totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        public final String getTotalUpfrontPrice() {
            return this.totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        public GetHostReservationPurchasePreviewResponse build() {
            return new GetHostReservationPurchasePreviewResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetHostReservationPurchasePreviewResponse> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder purchase(Collection<Purchase> var1);

        public Builder purchase(Purchase ... var1);

        public Builder totalHourlyPrice(String var1);

        public Builder totalUpfrontPrice(String var1);
    }
}

