/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.RequestHostIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHostReservationPurchasePreviewRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetHostReservationPurchasePreviewRequest> {
    private final List<String> hostIdSet;
    private final String offeringId;

    private GetHostReservationPurchasePreviewRequest(BuilderImpl builder) {
        this.hostIdSet = builder.hostIdSet;
        this.offeringId = builder.offeringId;
    }

    public List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostIdSet() == null ? 0 : this.hostIdSet().hashCode());
        hashCode = 31 * hashCode + (this.offeringId() == null ? 0 : this.offeringId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewRequest)) {
            return false;
        }
        GetHostReservationPurchasePreviewRequest other = (GetHostReservationPurchasePreviewRequest)((Object)obj);
        if (other.hostIdSet() == null ^ this.hostIdSet() == null) {
            return false;
        }
        if (other.hostIdSet() != null && !other.hostIdSet().equals(this.hostIdSet())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        return other.offeringId() == null || other.offeringId().equals(this.offeringId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostIdSet() != null) {
            sb.append("HostIdSet: ").append(this.hostIdSet()).append(",");
        }
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> hostIdSet = new SdkInternalList();
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewRequest model) {
            this.setHostIdSet(model.hostIdSet);
            this.setOfferingId(model.offeringId);
        }

        public final Collection<String> getHostIdSet() {
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            if (this.hostIdSet == null) {
                this.hostIdSet = new SdkInternalList(hostIdSet.length);
            }
            for (String e : hostIdSet) {
                this.hostIdSet.add(e);
            }
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        @SafeVarargs
        public final void setHostIdSet(String ... hostIdSet) {
            if (this.hostIdSet == null) {
                this.hostIdSet = new SdkInternalList(hostIdSet.length);
            }
            for (String e : hostIdSet) {
                this.hostIdSet.add(e);
            }
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public GetHostReservationPurchasePreviewRequest build() {
            return new GetHostReservationPurchasePreviewRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetHostReservationPurchasePreviewRequest> {
        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder offeringId(String var1);
    }
}

