/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.VpcEndpoint;
import software.amazon.awssdk.services.ec2.model.VpcEndpointSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcEndpointsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
    private final String nextToken;
    private final List<VpcEndpoint> vpcEndpoints;

    private DescribeVpcEndpointsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.vpcEndpoints = builder.vpcEndpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VpcEndpoint> vpcEndpoints() {
        return this.vpcEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.vpcEndpoints() == null ? 0 : this.vpcEndpoints().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointsResponse)) {
            return false;
        }
        DescribeVpcEndpointsResponse other = (DescribeVpcEndpointsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.vpcEndpoints() == null ^ this.vpcEndpoints() == null) {
            return false;
        }
        return other.vpcEndpoints() == null || other.vpcEndpoints().equals(this.vpcEndpoints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.vpcEndpoints() != null) {
            sb.append("VpcEndpoints: ").append(this.vpcEndpoints()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VpcEndpoint> vpcEndpoints = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointsResponse model) {
            this.setNextToken(model.nextToken);
            this.setVpcEndpoints(model.vpcEndpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VpcEndpoint> getVpcEndpoints() {
            return this.vpcEndpoints;
        }

        @Override
        public final Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(VpcEndpoint ... vpcEndpoints) {
            if (this.vpcEndpoints == null) {
                this.vpcEndpoints = new SdkInternalList(vpcEndpoints.length);
            }
            for (VpcEndpoint e : vpcEndpoints) {
                this.vpcEndpoints.add(e);
            }
            return this;
        }

        public final void setVpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copy(vpcEndpoints);
        }

        @SafeVarargs
        public final void setVpcEndpoints(VpcEndpoint ... vpcEndpoints) {
            if (this.vpcEndpoints == null) {
                this.vpcEndpoints = new SdkInternalList(vpcEndpoints.length);
            }
            for (VpcEndpoint e : vpcEndpoints) {
                this.vpcEndpoints.add(e);
            }
        }

        public DescribeVpcEndpointsResponse build() {
            return new DescribeVpcEndpointsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
        public Builder nextToken(String var1);

        public Builder vpcEndpoints(Collection<VpcEndpoint> var1);

        public Builder vpcEndpoints(VpcEndpoint ... var1);
    }
}

