/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.VolumeModification;
import software.amazon.awssdk.services.ec2.model.VolumeModificationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumesModificationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVolumesModificationsResponse> {
    private final List<VolumeModification> volumesModifications;
    private final String nextToken;

    private DescribeVolumesModificationsResponse(BuilderImpl builder) {
        this.volumesModifications = builder.volumesModifications;
        this.nextToken = builder.nextToken;
    }

    public List<VolumeModification> volumesModifications() {
        return this.volumesModifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumesModifications() == null ? 0 : this.volumesModifications().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesModificationsResponse)) {
            return false;
        }
        DescribeVolumesModificationsResponse other = (DescribeVolumesModificationsResponse)((Object)obj);
        if (other.volumesModifications() == null ^ this.volumesModifications() == null) {
            return false;
        }
        if (other.volumesModifications() != null && !other.volumesModifications().equals(this.volumesModifications())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumesModifications() != null) {
            sb.append("VolumesModifications: ").append(this.volumesModifications()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<VolumeModification> volumesModifications = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumesModificationsResponse model) {
            this.setVolumesModifications(model.volumesModifications);
            this.setNextToken(model.nextToken);
        }

        public final Collection<VolumeModification> getVolumesModifications() {
            return this.volumesModifications;
        }

        @Override
        public final Builder volumesModifications(Collection<VolumeModification> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copy(volumesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesModifications(VolumeModification ... volumesModifications) {
            if (this.volumesModifications == null) {
                this.volumesModifications = new SdkInternalList(volumesModifications.length);
            }
            for (VolumeModification e : volumesModifications) {
                this.volumesModifications.add(e);
            }
            return this;
        }

        public final void setVolumesModifications(Collection<VolumeModification> volumesModifications) {
            this.volumesModifications = VolumeModificationListCopier.copy(volumesModifications);
        }

        @SafeVarargs
        public final void setVolumesModifications(VolumeModification ... volumesModifications) {
            if (this.volumesModifications == null) {
                this.volumesModifications = new SdkInternalList(volumesModifications.length);
            }
            for (VolumeModification e : volumesModifications) {
                this.volumesModifications.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeVolumesModificationsResponse build() {
            return new DescribeVolumesModificationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVolumesModificationsResponse> {
        public Builder volumesModifications(Collection<VolumeModification> var1);

        public Builder volumesModifications(VolumeModification ... var1);

        public Builder nextToken(String var1);
    }
}

