/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVolumeAttributeResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVolumeAttributeResponse> {
    private final Boolean autoEnableIO;
    private final List<ProductCode> productCodes;
    private final String volumeId;

    private DescribeVolumeAttributeResponse(BuilderImpl builder) {
        this.autoEnableIO = builder.autoEnableIO;
        this.productCodes = builder.productCodes;
        this.volumeId = builder.volumeId;
    }

    public Boolean autoEnableIO() {
        return this.autoEnableIO;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoEnableIO() == null ? 0 : this.autoEnableIO().hashCode());
        hashCode = 31 * hashCode + (this.productCodes() == null ? 0 : this.productCodes().hashCode());
        hashCode = 31 * hashCode + (this.volumeId() == null ? 0 : this.volumeId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeAttributeResponse)) {
            return false;
        }
        DescribeVolumeAttributeResponse other = (DescribeVolumeAttributeResponse)((Object)obj);
        if (other.autoEnableIO() == null ^ this.autoEnableIO() == null) {
            return false;
        }
        if (other.autoEnableIO() != null && !other.autoEnableIO().equals(this.autoEnableIO())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        return other.volumeId() == null || other.volumeId().equals(this.volumeId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoEnableIO() != null) {
            sb.append("AutoEnableIO: ").append(this.autoEnableIO()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean autoEnableIO;
        private List<ProductCode> productCodes = new SdkInternalList();
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeAttributeResponse model) {
            this.setAutoEnableIO(model.autoEnableIO);
            this.setProductCodes(model.productCodes);
            this.setVolumeId(model.volumeId);
        }

        public final Boolean getAutoEnableIO() {
            return this.autoEnableIO;
        }

        @Override
        public final Builder autoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
            return this;
        }

        public final void setAutoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
        }

        public final Collection<ProductCode> getProductCodes() {
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            if (this.productCodes == null) {
                this.productCodes = new SdkInternalList(productCodes.length);
            }
            for (ProductCode e : productCodes) {
                this.productCodes.add(e);
            }
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        @SafeVarargs
        public final void setProductCodes(ProductCode ... productCodes) {
            if (this.productCodes == null) {
                this.productCodes = new SdkInternalList(productCodes.length);
            }
            for (ProductCode e : productCodes) {
                this.productCodes.add(e);
            }
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public DescribeVolumeAttributeResponse build() {
            return new DescribeVolumeAttributeResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVolumeAttributeResponse> {
        public Builder autoEnableIO(Boolean var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder volumeId(String var1);
    }
}

