/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotFleetRequestsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSpotFleetRequestsRequest> {
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> spotFleetRequestIds;

    private DescribeSpotFleetRequestsRequest(BuilderImpl builder) {
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestIds = builder.spotFleetRequestIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> spotFleetRequestIds() {
        return this.spotFleetRequestIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestIds() == null ? 0 : this.spotFleetRequestIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestsRequest)) {
            return false;
        }
        DescribeSpotFleetRequestsRequest other = (DescribeSpotFleetRequestsRequest)((Object)obj);
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.spotFleetRequestIds() == null ^ this.spotFleetRequestIds() == null) {
            return false;
        }
        return other.spotFleetRequestIds() == null || other.spotFleetRequestIds().equals(this.spotFleetRequestIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.spotFleetRequestIds() != null) {
            sb.append("SpotFleetRequestIds: ").append(this.spotFleetRequestIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> spotFleetRequestIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestsRequest model) {
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setSpotFleetRequestIds(model.spotFleetRequestIds);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getSpotFleetRequestIds() {
            return this.spotFleetRequestIds;
        }

        @Override
        public final Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestIds(String ... spotFleetRequestIds) {
            if (this.spotFleetRequestIds == null) {
                this.spotFleetRequestIds = new SdkInternalList(spotFleetRequestIds.length);
            }
            for (String e : spotFleetRequestIds) {
                this.spotFleetRequestIds.add(e);
            }
            return this;
        }

        public final void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
        }

        @SafeVarargs
        public final void setSpotFleetRequestIds(String ... spotFleetRequestIds) {
            if (this.spotFleetRequestIds == null) {
                this.spotFleetRequestIds = new SdkInternalList(spotFleetRequestIds.length);
            }
            for (String e : spotFleetRequestIds) {
                this.spotFleetRequestIds.add(e);
            }
        }

        public DescribeSpotFleetRequestsRequest build() {
            return new DescribeSpotFleetRequestsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSpotFleetRequestsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder spotFleetRequestIds(Collection<String> var1);

        public Builder spotFleetRequestIds(String ... var1);
    }
}

