/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ActiveInstance;
import software.amazon.awssdk.services.ec2.model.ActiveInstanceSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotFleetInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
    private final List<ActiveInstance> activeInstances;
    private final String nextToken;
    private final String spotFleetRequestId;

    private DescribeSpotFleetInstancesResponse(BuilderImpl builder) {
        this.activeInstances = builder.activeInstances;
        this.nextToken = builder.nextToken;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    public List<ActiveInstance> activeInstances() {
        return this.activeInstances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String spotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activeInstances() == null ? 0 : this.activeInstances().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.spotFleetRequestId() == null ? 0 : this.spotFleetRequestId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetInstancesResponse)) {
            return false;
        }
        DescribeSpotFleetInstancesResponse other = (DescribeSpotFleetInstancesResponse)((Object)obj);
        if (other.activeInstances() == null ^ this.activeInstances() == null) {
            return false;
        }
        if (other.activeInstances() != null && !other.activeInstances().equals(this.activeInstances())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.spotFleetRequestId() == null ^ this.spotFleetRequestId() == null) {
            return false;
        }
        return other.spotFleetRequestId() == null || other.spotFleetRequestId().equals(this.spotFleetRequestId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeInstances() != null) {
            sb.append("ActiveInstances: ").append(this.activeInstances()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.spotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(this.spotFleetRequestId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ActiveInstance> activeInstances = new SdkInternalList();
        private String nextToken;
        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetInstancesResponse model) {
            this.setActiveInstances(model.activeInstances);
            this.setNextToken(model.nextToken);
            this.setSpotFleetRequestId(model.spotFleetRequestId);
        }

        public final Collection<ActiveInstance> getActiveInstances() {
            return this.activeInstances;
        }

        @Override
        public final Builder activeInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeInstances(ActiveInstance ... activeInstances) {
            if (this.activeInstances == null) {
                this.activeInstances = new SdkInternalList(activeInstances.length);
            }
            for (ActiveInstance e : activeInstances) {
                this.activeInstances.add(e);
            }
            return this;
        }

        public final void setActiveInstances(Collection<ActiveInstance> activeInstances) {
            this.activeInstances = ActiveInstanceSetCopier.copy(activeInstances);
        }

        @SafeVarargs
        public final void setActiveInstances(ActiveInstance ... activeInstances) {
            if (this.activeInstances == null) {
                this.activeInstances = new SdkInternalList(activeInstances.length);
            }
            for (ActiveInstance e : activeInstances) {
                this.activeInstances.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSpotFleetRequestId() {
            return this.spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        public DescribeSpotFleetInstancesResponse build() {
            return new DescribeSpotFleetInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSpotFleetInstancesResponse> {
        public Builder activeInstances(Collection<ActiveInstance> var1);

        public Builder activeInstances(ActiveInstance ... var1);

        public Builder nextToken(String var1);

        public Builder spotFleetRequestId(String var1);
    }
}

