/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.InternetGateway;
import software.amazon.awssdk.services.ec2.model.InternetGatewayListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInternetGatewaysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
    private final List<InternetGateway> internetGateways;

    private DescribeInternetGatewaysResponse(BuilderImpl builder) {
        this.internetGateways = builder.internetGateways;
    }

    public List<InternetGateway> internetGateways() {
        return this.internetGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.internetGateways() == null ? 0 : this.internetGateways().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInternetGatewaysResponse)) {
            return false;
        }
        DescribeInternetGatewaysResponse other = (DescribeInternetGatewaysResponse)((Object)obj);
        if (other.internetGateways() == null ^ this.internetGateways() == null) {
            return false;
        }
        return other.internetGateways() == null || other.internetGateways().equals(this.internetGateways());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.internetGateways() != null) {
            sb.append("InternetGateways: ").append(this.internetGateways()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InternetGateway> internetGateways = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInternetGatewaysResponse model) {
            this.setInternetGateways(model.internetGateways);
        }

        public final Collection<InternetGateway> getInternetGateways() {
            return this.internetGateways;
        }

        @Override
        public final Builder internetGateways(Collection<InternetGateway> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copy(internetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGateways(InternetGateway ... internetGateways) {
            if (this.internetGateways == null) {
                this.internetGateways = new SdkInternalList(internetGateways.length);
            }
            for (InternetGateway e : internetGateways) {
                this.internetGateways.add(e);
            }
            return this;
        }

        public final void setInternetGateways(Collection<InternetGateway> internetGateways) {
            this.internetGateways = InternetGatewayListCopier.copy(internetGateways);
        }

        @SafeVarargs
        public final void setInternetGateways(InternetGateway ... internetGateways) {
            if (this.internetGateways == null) {
                this.internetGateways = new SdkInternalList(internetGateways.length);
            }
            for (InternetGateway e : internetGateways) {
                this.internetGateways.add(e);
            }
        }

        public DescribeInternetGatewaysResponse build() {
            return new DescribeInternetGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInternetGatewaysResponse> {
        public Builder internetGateways(Collection<InternetGateway> var1);

        public Builder internetGateways(InternetGateway ... var1);
    }
}

