/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.RequestHostIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeHostsRequest> {
    private final List<Filter> filter;
    private final List<String> hostIds;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeHostsRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.hostIds = builder.hostIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<Filter> filter() {
        return this.filter;
    }

    public List<String> hostIds() {
        return this.hostIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.hostIds() == null ? 0 : this.hostIds().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsRequest)) {
            return false;
        }
        DescribeHostsRequest other = (DescribeHostsRequest)((Object)obj);
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.hostIds() == null ^ this.hostIds() == null) {
            return false;
        }
        if (other.hostIds() != null && !other.hostIds().equals(this.hostIds())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.hostIds() != null) {
            sb.append("HostIds: ").append(this.hostIds()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filter = new SdkInternalList();
        private List<String> hostIds = new SdkInternalList();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostsRequest model) {
            this.setFilter(model.filter);
            this.setHostIds(model.hostIds);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Filter> getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter ... filter) {
            if (this.filter == null) {
                this.filter = new SdkInternalList(filter.length);
            }
            for (Filter e : filter) {
                this.filter.add(e);
            }
            return this;
        }

        public final void setFilter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
        }

        @SafeVarargs
        public final void setFilter(Filter ... filter) {
            if (this.filter == null) {
                this.filter = new SdkInternalList(filter.length);
            }
            for (Filter e : filter) {
                this.filter.add(e);
            }
        }

        public final Collection<String> getHostIds() {
            return this.hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            if (this.hostIds == null) {
                this.hostIds = new SdkInternalList(hostIds.length);
            }
            for (String e : hostIds) {
                this.hostIds.add(e);
            }
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = RequestHostIdListCopier.copy(hostIds);
        }

        @SafeVarargs
        public final void setHostIds(String ... hostIds) {
            if (this.hostIds == null) {
                this.hostIds = new SdkInternalList(hostIds.length);
            }
            for (String e : hostIds) {
                this.hostIds.add(e);
            }
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeHostsRequest build() {
            return new DescribeHostsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHostsRequest> {
        public Builder filter(Collection<Filter> var1);

        public Builder filter(Filter ... var1);

        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

