/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.HostReservation;
import software.amazon.awssdk.services.ec2.model.HostReservationSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostReservationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHostReservationsResponse> {
    private final List<HostReservation> hostReservationSet;
    private final String nextToken;

    private DescribeHostReservationsResponse(BuilderImpl builder) {
        this.hostReservationSet = builder.hostReservationSet;
        this.nextToken = builder.nextToken;
    }

    public List<HostReservation> hostReservationSet() {
        return this.hostReservationSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostReservationSet() == null ? 0 : this.hostReservationSet().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsResponse)) {
            return false;
        }
        DescribeHostReservationsResponse other = (DescribeHostReservationsResponse)((Object)obj);
        if (other.hostReservationSet() == null ^ this.hostReservationSet() == null) {
            return false;
        }
        if (other.hostReservationSet() != null && !other.hostReservationSet().equals(this.hostReservationSet())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostReservationSet() != null) {
            sb.append("HostReservationSet: ").append(this.hostReservationSet()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<HostReservation> hostReservationSet = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsResponse model) {
            this.setHostReservationSet(model.hostReservationSet);
            this.setNextToken(model.nextToken);
        }

        public final Collection<HostReservation> getHostReservationSet() {
            return this.hostReservationSet;
        }

        @Override
        public final Builder hostReservationSet(Collection<HostReservation> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copy(hostReservationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationSet(HostReservation ... hostReservationSet) {
            if (this.hostReservationSet == null) {
                this.hostReservationSet = new SdkInternalList(hostReservationSet.length);
            }
            for (HostReservation e : hostReservationSet) {
                this.hostReservationSet.add(e);
            }
            return this;
        }

        public final void setHostReservationSet(Collection<HostReservation> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copy(hostReservationSet);
        }

        @SafeVarargs
        public final void setHostReservationSet(HostReservation ... hostReservationSet) {
            if (this.hostReservationSet == null) {
                this.hostReservationSet = new SdkInternalList(hostReservationSet.length);
            }
            for (HostReservation e : hostReservationSet) {
                this.hostReservationSet.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeHostReservationsResponse build() {
            return new DescribeHostReservationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHostReservationsResponse> {
        public Builder hostReservationSet(Collection<HostReservation> var1);

        public Builder hostReservationSet(HostReservation ... var1);

        public Builder nextToken(String var1);
    }
}

