/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.AccountAttributeName;
import software.amazon.awssdk.services.ec2.model.AccountAttributeNameStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAccountAttributesRequest> {
    private final List<String> attributeNames;

    private DescribeAccountAttributesRequest(BuilderImpl builder) {
        this.attributeNames = builder.attributeNames;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeNames() == null ? 0 : this.attributeNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesRequest)) {
            return false;
        }
        DescribeAccountAttributesRequest other = (DescribeAccountAttributesRequest)((Object)obj);
        if (other.attributeNames() == null ^ this.attributeNames() == null) {
            return false;
        }
        return other.attributeNames() == null || other.attributeNames().equals(this.attributeNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeNames() != null) {
            sb.append("AttributeNames: ").append(this.attributeNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> attributeNames = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesRequest model) {
            this.setAttributeNames(model.attributeNames);
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AccountAttributeNameStringListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList(attributeNames.length);
            }
            for (String e : attributeNames) {
                this.attributeNames.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(AccountAttributeName ... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList(attributeNames.length);
            }
            for (AccountAttributeName ele : attributeNames) {
                this.attributeNames.add(ele.toString());
            }
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AccountAttributeNameStringListCopier.copy(attributeNames);
        }

        @SafeVarargs
        public final void setAttributeNames(String ... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList(attributeNames.length);
            }
            for (String e : attributeNames) {
                this.attributeNames.add(e);
            }
        }

        @SafeVarargs
        public final void setAttributeNames(AccountAttributeName ... attributeNames) {
            if (this.attributeNames == null) {
                this.attributeNames = new SdkInternalList(attributeNames.length);
            }
            for (AccountAttributeName ele : attributeNames) {
                this.attributeNames.add(ele.toString());
            }
        }

        public DescribeAccountAttributesRequest build() {
            return new DescribeAccountAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAccountAttributesRequest> {
        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder attributeNames(AccountAttributeName ... var1);
    }
}

