/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVolumeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateVolumeRequest> {
    private final String availabilityZone;
    private final Boolean encrypted;
    private final Integer iops;
    private final String kmsKeyId;
    private final Integer size;
    private final String snapshotId;
    private final String volumeType;
    private final List<TagSpecification> tagSpecifications;

    private CreateVolumeRequest(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.encrypted = builder.encrypted;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.volumeType = builder.volumeType;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public Integer iops() {
        return this.iops;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Integer size() {
        return this.size;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.encrypted() == null ? 0 : this.encrypted().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        hashCode = 31 * hashCode + (this.snapshotId() == null ? 0 : this.snapshotId().hashCode());
        hashCode = 31 * hashCode + (this.volumeType() == null ? 0 : this.volumeType().hashCode());
        hashCode = 31 * hashCode + (this.tagSpecifications() == null ? 0 : this.tagSpecifications().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeRequest)) {
            return false;
        }
        CreateVolumeRequest other = (CreateVolumeRequest)((Object)obj);
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        if (other.snapshotId() != null && !other.snapshotId().equals(this.snapshotId())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.tagSpecifications() == null ^ this.tagSpecifications() == null) {
            return false;
        }
        return other.tagSpecifications() == null || other.tagSpecifications().equals(this.tagSpecifications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.volumeType() != null) {
            sb.append("VolumeType: ").append(this.volumeType()).append(",");
        }
        if (this.tagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.tagSpecifications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Boolean encrypted;
        private Integer iops;
        private String kmsKeyId;
        private Integer size;
        private String snapshotId;
        private String volumeType;
        private List<TagSpecification> tagSpecifications = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumeRequest model) {
            this.setAvailabilityZone(model.availabilityZone);
            this.setEncrypted(model.encrypted);
            this.setIops(model.iops);
            this.setKmsKeyId(model.kmsKeyId);
            this.setSize(model.size);
            this.setSnapshotId(model.snapshotId);
            this.setVolumeType(model.volumeType);
            this.setTagSpecifications(model.tagSpecifications);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final void setVolumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
        }

        public final Collection<TagSpecification> getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            if (this.tagSpecifications == null) {
                this.tagSpecifications = new SdkInternalList(tagSpecifications.length);
            }
            for (TagSpecification e : tagSpecifications) {
                this.tagSpecifications.add(e);
            }
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
        }

        @SafeVarargs
        public final void setTagSpecifications(TagSpecification ... tagSpecifications) {
            if (this.tagSpecifications == null) {
                this.tagSpecifications = new SdkInternalList(tagSpecifications.length);
            }
            for (TagSpecification e : tagSpecifications) {
                this.tagSpecifications.add(e);
            }
        }

        public CreateVolumeRequest build() {
            return new CreateVolumeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateVolumeRequest> {
        public Builder availabilityZone(String var1);

        public Builder encrypted(Boolean var1);

        public Builder iops(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder size(Integer var1);

        public Builder snapshotId(String var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);
    }
}

