/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateImageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateImageRequest> {
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String description;
    private final String instanceId;
    private final String name;
    private final Boolean noReboot;

    private CreateImageRequest(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.noReboot = builder.noReboot;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String description() {
        return this.description;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String name() {
        return this.name;
    }

    public Boolean noReboot() {
        return this.noReboot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.noReboot() == null ? 0 : this.noReboot().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest)((Object)obj);
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.noReboot() == null ^ this.noReboot() == null) {
            return false;
        }
        return other.noReboot() == null || other.noReboot().equals(this.noReboot());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.noReboot() != null) {
            sb.append("NoReboot: ").append(this.noReboot()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings = new SdkInternalList();
        private String description;
        private String instanceId;
        private String name;
        private Boolean noReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRequest model) {
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setDescription(model.description);
            this.setInstanceId(model.instanceId);
            this.setName(model.name);
            this.setNoReboot(model.noReboot);
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            if (this.blockDeviceMappings == null) {
                this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings.length);
            }
            for (BlockDeviceMapping e : blockDeviceMappings) {
                this.blockDeviceMappings.add(e);
            }
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            if (this.blockDeviceMappings == null) {
                this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings.length);
            }
            for (BlockDeviceMapping e : blockDeviceMappings) {
                this.blockDeviceMappings.add(e);
            }
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getNoReboot() {
            return this.noReboot;
        }

        @Override
        public final Builder noReboot(Boolean noReboot) {
            this.noReboot = noReboot;
            return this;
        }

        public final void setNoReboot(Boolean noReboot) {
            this.noReboot = noReboot;
        }

        public CreateImageRequest build() {
            return new CreateImageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateImageRequest> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder description(String var1);

        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder noReboot(Boolean var1);
    }
}

