/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    INVALID_CUSTOMER_KEY("INVALID_CUSTOMER_KEY"),
    INVALID_PAGE_TOKEN("INVALID_PAGE_TOKEN"),
    INVALID_BLOCK_TOKEN("INVALID_BLOCK_TOKEN"),
    INVALID_GRANT_TOKEN("INVALID_GRANT_TOKEN"),
    INVALID_SNAPSHOT_ID("INVALID_SNAPSHOT_ID"),
    UNRELATED_SNAPSHOTS("UNRELATED_SNAPSHOTS"),
    INVALID_BLOCK("INVALID_BLOCK"),
    INVALID_CONTENT_ENCODING("INVALID_CONTENT_ENCODING"),
    INVALID_TAG("INVALID_TAG"),
    INVALID_DEPENDENCY_REQUEST("INVALID_DEPENDENCY_REQUEST"),
    INVALID_PARAMETER_VALUE("INVALID_PARAMETER_VALUE"),
    INVALID_VOLUME_SIZE("INVALID_VOLUME_SIZE"),
    CONFLICTING_BLOCK_UPDATE("CONFLICTING_BLOCK_UPDATE"),
    INVALID_IMAGE_ID("INVALID_IMAGE_ID"),
    WRITE_REQUEST_TIMEOUT("WRITE_REQUEST_TIMEOUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

