/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ebs.model.EbsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChangedBlocksRequest
extends EbsRequest
implements ToCopyableBuilder<Builder, ListChangedBlocksRequest> {
    private static final SdkField<String> FIRST_SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstSnapshotId").getter(ListChangedBlocksRequest.getter(ListChangedBlocksRequest::firstSnapshotId)).setter(ListChangedBlocksRequest.setter(Builder::firstSnapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("firstSnapshotId").build()}).build();
    private static final SdkField<String> SECOND_SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondSnapshotId").getter(ListChangedBlocksRequest.getter(ListChangedBlocksRequest::secondSnapshotId)).setter(ListChangedBlocksRequest.setter(Builder::secondSnapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("secondSnapshotId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChangedBlocksRequest.getter(ListChangedBlocksRequest::nextToken)).setter(ListChangedBlocksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pageToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListChangedBlocksRequest.getter(ListChangedBlocksRequest::maxResults)).setter(ListChangedBlocksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<Integer> STARTING_BLOCK_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartingBlockIndex").getter(ListChangedBlocksRequest.getter(ListChangedBlocksRequest::startingBlockIndex)).setter(ListChangedBlocksRequest.setter(Builder::startingBlockIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startingBlockIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_SNAPSHOT_ID_FIELD, SECOND_SNAPSHOT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STARTING_BLOCK_INDEX_FIELD));
    private final String firstSnapshotId;
    private final String secondSnapshotId;
    private final String nextToken;
    private final Integer maxResults;
    private final Integer startingBlockIndex;

    private ListChangedBlocksRequest(BuilderImpl builder) {
        super(builder);
        this.firstSnapshotId = builder.firstSnapshotId;
        this.secondSnapshotId = builder.secondSnapshotId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startingBlockIndex = builder.startingBlockIndex;
    }

    public String firstSnapshotId() {
        return this.firstSnapshotId;
    }

    public String secondSnapshotId() {
        return this.secondSnapshotId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Integer startingBlockIndex() {
        return this.startingBlockIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.firstSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingBlockIndex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangedBlocksRequest)) {
            return false;
        }
        ListChangedBlocksRequest other = (ListChangedBlocksRequest)((Object)obj);
        return Objects.equals(this.firstSnapshotId(), other.firstSnapshotId()) && Objects.equals(this.secondSnapshotId(), other.secondSnapshotId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.startingBlockIndex(), other.startingBlockIndex());
    }

    public String toString() {
        return ToString.builder((String)"ListChangedBlocksRequest").add("FirstSnapshotId", (Object)this.firstSnapshotId()).add("SecondSnapshotId", (Object)this.secondSnapshotId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StartingBlockIndex", (Object)this.startingBlockIndex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirstSnapshotId": {
                return Optional.ofNullable(clazz.cast(this.firstSnapshotId()));
            }
            case "SecondSnapshotId": {
                return Optional.ofNullable(clazz.cast(this.secondSnapshotId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StartingBlockIndex": {
                return Optional.ofNullable(clazz.cast(this.startingBlockIndex()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChangedBlocksRequest, T> g) {
        return obj -> g.apply((ListChangedBlocksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsRequest.BuilderImpl
    implements Builder {
        private String firstSnapshotId;
        private String secondSnapshotId;
        private String nextToken;
        private Integer maxResults;
        private Integer startingBlockIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangedBlocksRequest model) {
            super(model);
            this.firstSnapshotId(model.firstSnapshotId);
            this.secondSnapshotId(model.secondSnapshotId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.startingBlockIndex(model.startingBlockIndex);
        }

        public final String getFirstSnapshotId() {
            return this.firstSnapshotId;
        }

        @Override
        public final Builder firstSnapshotId(String firstSnapshotId) {
            this.firstSnapshotId = firstSnapshotId;
            return this;
        }

        public final void setFirstSnapshotId(String firstSnapshotId) {
            this.firstSnapshotId = firstSnapshotId;
        }

        public final String getSecondSnapshotId() {
            return this.secondSnapshotId;
        }

        @Override
        public final Builder secondSnapshotId(String secondSnapshotId) {
            this.secondSnapshotId = secondSnapshotId;
            return this;
        }

        public final void setSecondSnapshotId(String secondSnapshotId) {
            this.secondSnapshotId = secondSnapshotId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getStartingBlockIndex() {
            return this.startingBlockIndex;
        }

        @Override
        public final Builder startingBlockIndex(Integer startingBlockIndex) {
            this.startingBlockIndex = startingBlockIndex;
            return this;
        }

        public final void setStartingBlockIndex(Integer startingBlockIndex) {
            this.startingBlockIndex = startingBlockIndex;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChangedBlocksRequest build() {
            return new ListChangedBlocksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EbsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChangedBlocksRequest> {
        public Builder firstSnapshotId(String var1);

        public Builder secondSnapshotId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder startingBlockIndex(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

