/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ebs.model.EbsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSnapshotBlocksRequest
extends EbsRequest
implements ToCopyableBuilder<Builder, ListSnapshotBlocksRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(ListSnapshotBlocksRequest.getter(ListSnapshotBlocksRequest::snapshotId)).setter(ListSnapshotBlocksRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSnapshotBlocksRequest.getter(ListSnapshotBlocksRequest::nextToken)).setter(ListSnapshotBlocksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pageToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListSnapshotBlocksRequest.getter(ListSnapshotBlocksRequest::maxResults)).setter(ListSnapshotBlocksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<Integer> STARTING_BLOCK_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartingBlockIndex").getter(ListSnapshotBlocksRequest.getter(ListSnapshotBlocksRequest::startingBlockIndex)).setter(ListSnapshotBlocksRequest.setter(Builder::startingBlockIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startingBlockIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STARTING_BLOCK_INDEX_FIELD));
    private final String snapshotId;
    private final String nextToken;
    private final Integer maxResults;
    private final Integer startingBlockIndex;

    private ListSnapshotBlocksRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startingBlockIndex = builder.startingBlockIndex;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Integer startingBlockIndex() {
        return this.startingBlockIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingBlockIndex());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotBlocksRequest)) {
            return false;
        }
        ListSnapshotBlocksRequest other = (ListSnapshotBlocksRequest)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.startingBlockIndex(), other.startingBlockIndex());
    }

    public String toString() {
        return ToString.builder((String)"ListSnapshotBlocksRequest").add("SnapshotId", (Object)this.snapshotId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StartingBlockIndex", (Object)this.startingBlockIndex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StartingBlockIndex": {
                return Optional.ofNullable(clazz.cast(this.startingBlockIndex()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSnapshotBlocksRequest, T> g) {
        return obj -> g.apply((ListSnapshotBlocksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsRequest.BuilderImpl
    implements Builder {
        private String snapshotId;
        private String nextToken;
        private Integer maxResults;
        private Integer startingBlockIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSnapshotBlocksRequest model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.startingBlockIndex(model.startingBlockIndex);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getStartingBlockIndex() {
            return this.startingBlockIndex;
        }

        @Override
        public final Builder startingBlockIndex(Integer startingBlockIndex) {
            this.startingBlockIndex = startingBlockIndex;
            return this;
        }

        public final void setStartingBlockIndex(Integer startingBlockIndex) {
            this.startingBlockIndex = startingBlockIndex;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSnapshotBlocksRequest build() {
            return new ListSnapshotBlocksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EbsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSnapshotBlocksRequest> {
        public Builder snapshotId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder startingBlockIndex(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

