/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ebs.model.EbsResponse;
import software.amazon.awssdk.services.ebs.model.Status;
import software.amazon.awssdk.services.ebs.model.Tag;
import software.amazon.awssdk.services.ebs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSnapshotResponse
extends EbsResponse
implements ToCopyableBuilder<Builder, StartSnapshotResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartSnapshotResponse.getter(StartSnapshotResponse::description)).setter(StartSnapshotResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(StartSnapshotResponse.getter(StartSnapshotResponse::snapshotId)).setter(StartSnapshotResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(StartSnapshotResponse.getter(StartSnapshotResponse::ownerId)).setter(StartSnapshotResponse.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StartSnapshotResponse.getter(StartSnapshotResponse::statusAsString)).setter(StartSnapshotResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(StartSnapshotResponse.getter(StartSnapshotResponse::startTime)).setter(StartSnapshotResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Long> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeSize").getter(StartSnapshotResponse.getter(StartSnapshotResponse::volumeSize)).setter(StartSnapshotResponse.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()}).build();
    private static final SdkField<Integer> BLOCK_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BlockSize").getter(StartSnapshotResponse.getter(StartSnapshotResponse::blockSize)).setter(StartSnapshotResponse.setter(Builder::blockSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSize").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartSnapshotResponse.getter(StartSnapshotResponse::tags)).setter(StartSnapshotResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PARENT_SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentSnapshotId").getter(StartSnapshotResponse.getter(StartSnapshotResponse::parentSnapshotId)).setter(StartSnapshotResponse.setter(Builder::parentSnapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentSnapshotId").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(StartSnapshotResponse.getter(StartSnapshotResponse::kmsKeyArn)).setter(StartSnapshotResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, SNAPSHOT_ID_FIELD, OWNER_ID_FIELD, STATUS_FIELD, START_TIME_FIELD, VOLUME_SIZE_FIELD, BLOCK_SIZE_FIELD, TAGS_FIELD, PARENT_SNAPSHOT_ID_FIELD, KMS_KEY_ARN_FIELD));
    private final String description;
    private final String snapshotId;
    private final String ownerId;
    private final String status;
    private final Instant startTime;
    private final Long volumeSize;
    private final Integer blockSize;
    private final List<Tag> tags;
    private final String parentSnapshotId;
    private final String kmsKeyArn;

    private StartSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.snapshotId = builder.snapshotId;
        this.ownerId = builder.ownerId;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.volumeSize = builder.volumeSize;
        this.blockSize = builder.blockSize;
        this.tags = builder.tags;
        this.parentSnapshotId = builder.parentSnapshotId;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public String description() {
        return this.description;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Long volumeSize() {
        return this.volumeSize;
    }

    public Integer blockSize() {
        return this.blockSize;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String parentSnapshotId() {
        return this.parentSnapshotId;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parentSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSnapshotResponse)) {
            return false;
        }
        StartSnapshotResponse other = (StartSnapshotResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.blockSize(), other.blockSize()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.parentSnapshotId(), other.parentSnapshotId()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public String toString() {
        return ToString.builder((String)"StartSnapshotResponse").add("Description", (Object)this.description()).add("SnapshotId", (Object)this.snapshotId()).add("OwnerId", (Object)this.ownerId()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("VolumeSize", (Object)this.volumeSize()).add("BlockSize", (Object)this.blockSize()).add("Tags", this.hasTags() ? this.tags() : null).add("ParentSnapshotId", (Object)this.parentSnapshotId()).add("KmsKeyArn", (Object)(this.kmsKeyArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "BlockSize": {
                return Optional.ofNullable(clazz.cast(this.blockSize()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ParentSnapshotId": {
                return Optional.ofNullable(clazz.cast(this.parentSnapshotId()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSnapshotResponse, T> g) {
        return obj -> g.apply((StartSnapshotResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsResponse.BuilderImpl
    implements Builder {
        private String description;
        private String snapshotId;
        private String ownerId;
        private String status;
        private Instant startTime;
        private Long volumeSize;
        private Integer blockSize;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String parentSnapshotId;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSnapshotResponse model) {
            super(model);
            this.description(model.description);
            this.snapshotId(model.snapshotId);
            this.ownerId(model.ownerId);
            this.status(model.status);
            this.startTime(model.startTime);
            this.volumeSize(model.volumeSize);
            this.blockSize(model.blockSize);
            this.tags(model.tags);
            this.parentSnapshotId(model.parentSnapshotId);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Long getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final Builder volumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final Integer getBlockSize() {
            return this.blockSize;
        }

        @Override
        public final Builder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public final void setBlockSize(Integer blockSize) {
            this.blockSize = blockSize;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getParentSnapshotId() {
            return this.parentSnapshotId;
        }

        @Override
        public final Builder parentSnapshotId(String parentSnapshotId) {
            this.parentSnapshotId = parentSnapshotId;
            return this;
        }

        public final void setParentSnapshotId(String parentSnapshotId) {
            this.parentSnapshotId = parentSnapshotId;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public StartSnapshotResponse build() {
            return new StartSnapshotResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EbsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSnapshotResponse> {
        public Builder description(String var1);

        public Builder snapshotId(String var1);

        public Builder ownerId(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder startTime(Instant var1);

        public Builder volumeSize(Long var1);

        public Builder blockSize(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder parentSnapshotId(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

