/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSnapshotBlockRequest extends EbsRequest implements
        ToCopyableBuilder<GetSnapshotBlockRequest.Builder, GetSnapshotBlockRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSnapshotBlockRequest::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotId").build()).build();

    private static final SdkField<Integer> BLOCK_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetSnapshotBlockRequest::blockIndex)).setter(setter(Builder::blockIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("blockIndex").build()).build();

    private static final SdkField<String> BLOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSnapshotBlockRequest::blockToken)).setter(setter(Builder::blockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("blockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            BLOCK_INDEX_FIELD, BLOCK_TOKEN_FIELD));

    private final String snapshotId;

    private final Integer blockIndex;

    private final String blockToken;

    private GetSnapshotBlockRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.blockIndex = builder.blockIndex;
        this.blockToken = builder.blockToken;
    }

    /**
     * <p>
     * The ID of the snapshot containing the block from which to get data.
     * </p>
     * 
     * @return The ID of the snapshot containing the block from which to get data.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The block index of the block from which to get data.
     * </p>
     * <p>
     * Obtain the <code>BlockIndex</code> by running the <code>ListChangedBlocks</code> or
     * <code>ListSnapshotBlocks</code> operations.
     * </p>
     * 
     * @return The block index of the block from which to get data.</p>
     *         <p>
     *         Obtain the <code>BlockIndex</code> by running the <code>ListChangedBlocks</code> or
     *         <code>ListSnapshotBlocks</code> operations.
     */
    public Integer blockIndex() {
        return blockIndex;
    }

    /**
     * <p>
     * The block token of the block from which to get data.
     * </p>
     * <p>
     * Obtain the <code>BlockToken</code> by running the <code>ListChangedBlocks</code> or
     * <code>ListSnapshotBlocks</code> operations.
     * </p>
     * 
     * @return The block token of the block from which to get data.</p>
     *         <p>
     *         Obtain the <code>BlockToken</code> by running the <code>ListChangedBlocks</code> or
     *         <code>ListSnapshotBlocks</code> operations.
     */
    public String blockToken() {
        return blockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(blockIndex());
        hashCode = 31 * hashCode + Objects.hashCode(blockToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnapshotBlockRequest)) {
            return false;
        }
        GetSnapshotBlockRequest other = (GetSnapshotBlockRequest) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(blockIndex(), other.blockIndex())
                && Objects.equals(blockToken(), other.blockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSnapshotBlockRequest").add("SnapshotId", snapshotId()).add("BlockIndex", blockIndex())
                .add("BlockToken", blockToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "BlockIndex":
            return Optional.ofNullable(clazz.cast(blockIndex()));
        case "BlockToken":
            return Optional.ofNullable(clazz.cast(blockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSnapshotBlockRequest, T> g) {
        return obj -> g.apply((GetSnapshotBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EbsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSnapshotBlockRequest> {
        /**
         * <p>
         * The ID of the snapshot containing the block from which to get data.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot containing the block from which to get data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The block index of the block from which to get data.
         * </p>
         * <p>
         * Obtain the <code>BlockIndex</code> by running the <code>ListChangedBlocks</code> or
         * <code>ListSnapshotBlocks</code> operations.
         * </p>
         * 
         * @param blockIndex
         *        The block index of the block from which to get data.</p>
         *        <p>
         *        Obtain the <code>BlockIndex</code> by running the <code>ListChangedBlocks</code> or
         *        <code>ListSnapshotBlocks</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockIndex(Integer blockIndex);

        /**
         * <p>
         * The block token of the block from which to get data.
         * </p>
         * <p>
         * Obtain the <code>BlockToken</code> by running the <code>ListChangedBlocks</code> or
         * <code>ListSnapshotBlocks</code> operations.
         * </p>
         * 
         * @param blockToken
         *        The block token of the block from which to get data.</p>
         *        <p>
         *        Obtain the <code>BlockToken</code> by running the <code>ListChangedBlocks</code> or
         *        <code>ListSnapshotBlocks</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockToken(String blockToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EbsRequest.BuilderImpl implements Builder {
        private String snapshotId;

        private Integer blockIndex;

        private String blockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnapshotBlockRequest model) {
            super(model);
            snapshotId(model.snapshotId);
            blockIndex(model.blockIndex);
            blockToken(model.blockToken);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getBlockIndex() {
            return blockIndex;
        }

        @Override
        public final Builder blockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
            return this;
        }

        public final void setBlockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
        }

        public final String getBlockToken() {
            return blockToken;
        }

        @Override
        public final Builder blockToken(String blockToken) {
            this.blockToken = blockToken;
            return this;
        }

        public final void setBlockToken(String blockToken) {
            this.blockToken = blockToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSnapshotBlockRequest build() {
            return new GetSnapshotBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
