/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ebs.EbsAsyncClient;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksRequest;
import software.amazon.awssdk.services.ebs.model.ListChangedBlocksResponse;

public class ListChangedBlocksPublisher
implements SdkPublisher<ListChangedBlocksResponse> {
    private final EbsAsyncClient client;
    private final ListChangedBlocksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChangedBlocksPublisher(EbsAsyncClient client, ListChangedBlocksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChangedBlocksPublisher(EbsAsyncClient client, ListChangedBlocksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChangedBlocksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChangedBlocksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChangedBlocksResponseFetcher
    implements AsyncPageFetcher<ListChangedBlocksResponse> {
        private ListChangedBlocksResponseFetcher() {
        }

        public boolean hasNextPage(ListChangedBlocksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChangedBlocksResponse> nextPage(ListChangedBlocksResponse previousPage) {
            if (previousPage == null) {
                return ListChangedBlocksPublisher.this.client.listChangedBlocks(ListChangedBlocksPublisher.this.firstRequest);
            }
            return ListChangedBlocksPublisher.this.client.listChangedBlocks((ListChangedBlocksRequest)((Object)ListChangedBlocksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

