/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChangedBlocksRequest extends EbsRequest implements
        ToCopyableBuilder<ListChangedBlocksRequest.Builder, ListChangedBlocksRequest> {
    private static final SdkField<String> FIRST_SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListChangedBlocksRequest::firstSnapshotId)).setter(setter(Builder::firstSnapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("firstSnapshotId").build())
            .build();

    private static final SdkField<String> SECOND_SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListChangedBlocksRequest::secondSnapshotId)).setter(setter(Builder::secondSnapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("secondSnapshotId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListChangedBlocksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pageToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListChangedBlocksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<Integer> STARTING_BLOCK_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListChangedBlocksRequest::startingBlockIndex)).setter(setter(Builder::startingBlockIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startingBlockIndex").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_SNAPSHOT_ID_FIELD,
            SECOND_SNAPSHOT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STARTING_BLOCK_INDEX_FIELD));

    private final String firstSnapshotId;

    private final String secondSnapshotId;

    private final String nextToken;

    private final Integer maxResults;

    private final Integer startingBlockIndex;

    private ListChangedBlocksRequest(BuilderImpl builder) {
        super(builder);
        this.firstSnapshotId = builder.firstSnapshotId;
        this.secondSnapshotId = builder.secondSnapshotId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startingBlockIndex = builder.startingBlockIndex;
    }

    /**
     * <p>
     * The ID of the first snapshot to use for the comparison.
     * </p>
     * 
     * @return The ID of the first snapshot to use for the comparison.
     */
    public String firstSnapshotId() {
        return firstSnapshotId;
    }

    /**
     * <p>
     * The ID of the second snapshot to use for the comparison.
     * </p>
     * 
     * @return The ID of the second snapshot to use for the comparison.
     */
    public String secondSnapshotId() {
        return secondSnapshotId;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of results to return.
     * </p>
     * 
     * @return The number of results to return.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The block index from which the comparison should start.
     * </p>
     * <p>
     * The list in the response will start from this block index or the next valid block index in the snapshots.
     * </p>
     * 
     * @return The block index from which the comparison should start.</p>
     *         <p>
     *         The list in the response will start from this block index or the next valid block index in the snapshots.
     */
    public Integer startingBlockIndex() {
        return startingBlockIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firstSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(secondSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(startingBlockIndex());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangedBlocksRequest)) {
            return false;
        }
        ListChangedBlocksRequest other = (ListChangedBlocksRequest) obj;
        return Objects.equals(firstSnapshotId(), other.firstSnapshotId())
                && Objects.equals(secondSnapshotId(), other.secondSnapshotId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(startingBlockIndex(), other.startingBlockIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListChangedBlocksRequest").add("FirstSnapshotId", firstSnapshotId())
                .add("SecondSnapshotId", secondSnapshotId()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("StartingBlockIndex", startingBlockIndex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirstSnapshotId":
            return Optional.ofNullable(clazz.cast(firstSnapshotId()));
        case "SecondSnapshotId":
            return Optional.ofNullable(clazz.cast(secondSnapshotId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StartingBlockIndex":
            return Optional.ofNullable(clazz.cast(startingBlockIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChangedBlocksRequest, T> g) {
        return obj -> g.apply((ListChangedBlocksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EbsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListChangedBlocksRequest> {
        /**
         * <p>
         * The ID of the first snapshot to use for the comparison.
         * </p>
         * 
         * @param firstSnapshotId
         *        The ID of the first snapshot to use for the comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSnapshotId(String firstSnapshotId);

        /**
         * <p>
         * The ID of the second snapshot to use for the comparison.
         * </p>
         * 
         * @param secondSnapshotId
         *        The ID of the second snapshot to use for the comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondSnapshotId(String secondSnapshotId);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The block index from which the comparison should start.
         * </p>
         * <p>
         * The list in the response will start from this block index or the next valid block index in the snapshots.
         * </p>
         * 
         * @param startingBlockIndex
         *        The block index from which the comparison should start.</p>
         *        <p>
         *        The list in the response will start from this block index or the next valid block index in the
         *        snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingBlockIndex(Integer startingBlockIndex);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EbsRequest.BuilderImpl implements Builder {
        private String firstSnapshotId;

        private String secondSnapshotId;

        private String nextToken;

        private Integer maxResults;

        private Integer startingBlockIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangedBlocksRequest model) {
            super(model);
            firstSnapshotId(model.firstSnapshotId);
            secondSnapshotId(model.secondSnapshotId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            startingBlockIndex(model.startingBlockIndex);
        }

        public final String getFirstSnapshotId() {
            return firstSnapshotId;
        }

        @Override
        public final Builder firstSnapshotId(String firstSnapshotId) {
            this.firstSnapshotId = firstSnapshotId;
            return this;
        }

        public final void setFirstSnapshotId(String firstSnapshotId) {
            this.firstSnapshotId = firstSnapshotId;
        }

        public final String getSecondSnapshotId() {
            return secondSnapshotId;
        }

        @Override
        public final Builder secondSnapshotId(String secondSnapshotId) {
            this.secondSnapshotId = secondSnapshotId;
            return this;
        }

        public final void setSecondSnapshotId(String secondSnapshotId) {
            this.secondSnapshotId = secondSnapshotId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getStartingBlockIndex() {
            return startingBlockIndex;
        }

        @Override
        public final Builder startingBlockIndex(Integer startingBlockIndex) {
            this.startingBlockIndex = startingBlockIndex;
            return this;
        }

        public final void setStartingBlockIndex(Integer startingBlockIndex) {
            this.startingBlockIndex = startingBlockIndex;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChangedBlocksRequest build() {
            return new ListChangedBlocksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
