/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WriteRequest> {
    private static final SdkField<PutRequest> PUT_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteRequest.getter(WriteRequest::putRequest)).setter(WriteRequest.setter(Builder::putRequest)).constructor(PutRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PutRequest").build()}).build();
    private static final SdkField<DeleteRequest> DELETE_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WriteRequest.getter(WriteRequest::deleteRequest)).setter(WriteRequest.setter(Builder::deleteRequest)).constructor(DeleteRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUT_REQUEST_FIELD, DELETE_REQUEST_FIELD));
    private static final long serialVersionUID = 1L;
    private final PutRequest putRequest;
    private final DeleteRequest deleteRequest;

    private WriteRequest(BuilderImpl builder) {
        this.putRequest = builder.putRequest;
        this.deleteRequest = builder.deleteRequest;
    }

    public PutRequest putRequest() {
        return this.putRequest;
    }

    public DeleteRequest deleteRequest() {
        return this.deleteRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.putRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRequest)) {
            return false;
        }
        WriteRequest other = (WriteRequest)obj;
        return Objects.equals(this.putRequest(), other.putRequest()) && Objects.equals(this.deleteRequest(), other.deleteRequest());
    }

    public String toString() {
        return ToString.builder((String)"WriteRequest").add("PutRequest", (Object)this.putRequest()).add("DeleteRequest", (Object)this.deleteRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PutRequest": {
                return Optional.ofNullable(clazz.cast(this.putRequest()));
            }
            case "DeleteRequest": {
                return Optional.ofNullable(clazz.cast(this.deleteRequest()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteRequest, T> g) {
        return obj -> g.apply((WriteRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PutRequest putRequest;
        private DeleteRequest deleteRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteRequest model) {
            this.putRequest(model.putRequest);
            this.deleteRequest(model.deleteRequest);
        }

        public final PutRequest.Builder getPutRequest() {
            return this.putRequest != null ? this.putRequest.toBuilder() : null;
        }

        @Override
        public final Builder putRequest(PutRequest putRequest) {
            this.putRequest = putRequest;
            return this;
        }

        public final void setPutRequest(PutRequest.BuilderImpl putRequest) {
            this.putRequest = putRequest != null ? putRequest.build() : null;
        }

        public final DeleteRequest.Builder getDeleteRequest() {
            return this.deleteRequest != null ? this.deleteRequest.toBuilder() : null;
        }

        @Override
        public final Builder deleteRequest(DeleteRequest deleteRequest) {
            this.deleteRequest = deleteRequest;
            return this;
        }

        public final void setDeleteRequest(DeleteRequest.BuilderImpl deleteRequest) {
            this.deleteRequest = deleteRequest != null ? deleteRequest.build() : null;
        }

        public WriteRequest build() {
            return new WriteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WriteRequest> {
        public Builder putRequest(PutRequest var1);

        default public Builder putRequest(Consumer<PutRequest.Builder> putRequest) {
            return this.putRequest((PutRequest)((PutRequest.Builder)PutRequest.builder().applyMutation(putRequest)).build());
        }

        public Builder deleteRequest(DeleteRequest var1);

        default public Builder deleteRequest(Consumer<DeleteRequest.Builder> deleteRequest) {
            return this.deleteRequest((DeleteRequest)((DeleteRequest.Builder)DeleteRequest.builder().applyMutation(deleteRequest)).build());
        }
    }
}

