/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlobalTableRequest extends DynamoDbRequest implements
        ToCopyableBuilder<CreateGlobalTableRequest.Builder, CreateGlobalTableRequest> {
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableName").getter(getter(CreateGlobalTableRequest::globalTableName))
            .setter(setter(Builder::globalTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()).build();

    private static final SdkField<List<Replica>> REPLICATION_GROUP_FIELD = SdkField
            .<List<Replica>> builder(MarshallingType.LIST)
            .memberName("ReplicationGroup")
            .getter(getter(CreateGlobalTableRequest::replicationGroup))
            .setter(setter(Builder::replicationGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Replica> builder(MarshallingType.SDK_POJO)
                                            .constructor(Replica::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLE_NAME_FIELD,
            REPLICATION_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String globalTableName;

    private final List<Replica> replicationGroup;

    private CreateGlobalTableRequest(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.replicationGroup = builder.replicationGroup;
    }

    /**
     * <p>
     * The global table name.
     * </p>
     * 
     * @return The global table name.
     */
    public final String globalTableName() {
        return globalTableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationGroup property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationGroup() {
        return replicationGroup != null && !(replicationGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Regions where the global table needs to be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationGroup} method.
     * </p>
     * 
     * @return The Regions where the global table needs to be created.
     */
    public final List<Replica> replicationGroup() {
        return replicationGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationGroup() ? replicationGroup() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalTableRequest)) {
            return false;
        }
        CreateGlobalTableRequest other = (CreateGlobalTableRequest) obj;
        return Objects.equals(globalTableName(), other.globalTableName()) && hasReplicationGroup() == other.hasReplicationGroup()
                && Objects.equals(replicationGroup(), other.replicationGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlobalTableRequest").add("GlobalTableName", globalTableName())
                .add("ReplicationGroup", hasReplicationGroup() ? replicationGroup() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalTableName":
            return Optional.ofNullable(clazz.cast(globalTableName()));
        case "ReplicationGroup":
            return Optional.ofNullable(clazz.cast(replicationGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GlobalTableName", GLOBAL_TABLE_NAME_FIELD);
        map.put("ReplicationGroup", REPLICATION_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalTableRequest, T> g) {
        return obj -> g.apply((CreateGlobalTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGlobalTableRequest> {
        /**
         * <p>
         * The global table name.
         * </p>
         * 
         * @param globalTableName
         *        The global table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableName(String globalTableName);

        /**
         * <p>
         * The Regions where the global table needs to be created.
         * </p>
         * 
         * @param replicationGroup
         *        The Regions where the global table needs to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroup(Collection<Replica> replicationGroup);

        /**
         * <p>
         * The Regions where the global table needs to be created.
         * </p>
         * 
         * @param replicationGroup
         *        The Regions where the global table needs to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroup(Replica... replicationGroup);

        /**
         * <p>
         * The Regions where the global table needs to be created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.Replica.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.dynamodb.model.Replica#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.Replica.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationGroup(List<Replica>)}.
         * 
         * @param replicationGroup
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.Replica.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationGroup(java.util.Collection<Replica>)
         */
        Builder replicationGroup(Consumer<Replica.Builder>... replicationGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String globalTableName;

        private List<Replica> replicationGroup = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalTableRequest model) {
            super(model);
            globalTableName(model.globalTableName);
            replicationGroup(model.replicationGroup);
        }

        public final String getGlobalTableName() {
            return globalTableName;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final List<Replica.Builder> getReplicationGroup() {
            List<Replica.Builder> result = ReplicaListCopier.copyToBuilder(this.replicationGroup);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationGroup(Collection<Replica.BuilderImpl> replicationGroup) {
            this.replicationGroup = ReplicaListCopier.copyFromBuilder(replicationGroup);
        }

        @Override
        public final Builder replicationGroup(Collection<Replica> replicationGroup) {
            this.replicationGroup = ReplicaListCopier.copy(replicationGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Replica... replicationGroup) {
            replicationGroup(Arrays.asList(replicationGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Consumer<Replica.Builder>... replicationGroup) {
            replicationGroup(Stream.of(replicationGroup).map(c -> Replica.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlobalTableRequest build() {
            return new CreateGlobalTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
