/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.TableClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableClassSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableClassSummary> {
    private static final SdkField<String> TABLE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableClass").getter(TableClassSummary.getter(TableClassSummary::tableClassAsString)).setter(TableClassSummary.setter(Builder::tableClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableClass").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateDateTime").getter(TableClassSummary.getter(TableClassSummary::lastUpdateDateTime)).setter(TableClassSummary.setter(Builder::lastUpdateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_CLASS_FIELD, LAST_UPDATE_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TableClass", TABLE_CLASS_FIELD);
            this.put("LastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String tableClass;
    private final Instant lastUpdateDateTime;

    private TableClassSummary(BuilderImpl builder) {
        this.tableClass = builder.tableClass;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
    }

    public final TableClass tableClass() {
        return TableClass.fromValue(this.tableClass);
    }

    public final String tableClassAsString() {
        return this.tableClass;
    }

    public final Instant lastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableClassSummary)) {
            return false;
        }
        TableClassSummary other = (TableClassSummary)obj;
        return Objects.equals(this.tableClassAsString(), other.tableClassAsString()) && Objects.equals(this.lastUpdateDateTime(), other.lastUpdateDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"TableClassSummary").add("TableClass", (Object)this.tableClassAsString()).add("LastUpdateDateTime", (Object)this.lastUpdateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableClass": {
                return Optional.ofNullable(clazz.cast(this.tableClassAsString()));
            }
            case "LastUpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableClassSummary, T> g) {
        return obj -> g.apply((TableClassSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableClass;
        private Instant lastUpdateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TableClassSummary model) {
            this.tableClass(model.tableClass);
            this.lastUpdateDateTime(model.lastUpdateDateTime);
        }

        public final String getTableClass() {
            return this.tableClass;
        }

        public final void setTableClass(String tableClass) {
            this.tableClass = tableClass;
        }

        @Override
        public final Builder tableClass(String tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        @Override
        public final Builder tableClass(TableClass tableClass) {
            this.tableClass(tableClass == null ? null : tableClass.toString());
            return this;
        }

        public final Instant getLastUpdateDateTime() {
            return this.lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public TableClassSummary build() {
            return new TableClassSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableClassSummary> {
        public Builder tableClass(String var1);

        public Builder tableClass(TableClass var1);

        public Builder lastUpdateDateTime(Instant var1);
    }
}

