/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.ContributorInsightsRuleListCopier;
import software.amazon.awssdk.services.dynamodb.model.ContributorInsightsStatus;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.FailureException;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeContributorInsightsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, DescribeContributorInsightsResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(DescribeContributorInsightsResponse.getter(DescribeContributorInsightsResponse::tableName)).setter(DescribeContributorInsightsResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(DescribeContributorInsightsResponse.getter(DescribeContributorInsightsResponse::indexName)).setter(DescribeContributorInsightsResponse.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<List<String>> CONTRIBUTOR_INSIGHTS_RULE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContributorInsightsRuleList").getter(DescribeContributorInsightsResponse.getter(DescribeContributorInsightsResponse::contributorInsightsRuleList)).setter(DescribeContributorInsightsResponse.setter(Builder::contributorInsightsRuleList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsRuleList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTRIBUTOR_INSIGHTS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContributorInsightsStatus").getter(DescribeContributorInsightsResponse.getter(DescribeContributorInsightsResponse::contributorInsightsStatusAsString)).setter(DescribeContributorInsightsResponse.setter(Builder::contributorInsightsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateDateTime").getter(DescribeContributorInsightsResponse.getter(DescribeContributorInsightsResponse::lastUpdateDateTime)).setter(DescribeContributorInsightsResponse.setter(Builder::lastUpdateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDateTime").build()}).build();
    private static final SdkField<FailureException> FAILURE_EXCEPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureException").getter(DescribeContributorInsightsResponse.getter(DescribeContributorInsightsResponse::failureException)).setter(DescribeContributorInsightsResponse.setter(Builder::failureException)).constructor(FailureException::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureException").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, INDEX_NAME_FIELD, CONTRIBUTOR_INSIGHTS_RULE_LIST_FIELD, CONTRIBUTOR_INSIGHTS_STATUS_FIELD, LAST_UPDATE_DATE_TIME_FIELD, FAILURE_EXCEPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("IndexName", INDEX_NAME_FIELD);
            this.put("ContributorInsightsRuleList", CONTRIBUTOR_INSIGHTS_RULE_LIST_FIELD);
            this.put("ContributorInsightsStatus", CONTRIBUTOR_INSIGHTS_STATUS_FIELD);
            this.put("LastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
            this.put("FailureException", FAILURE_EXCEPTION_FIELD);
        }
    });
    private final String tableName;
    private final String indexName;
    private final List<String> contributorInsightsRuleList;
    private final String contributorInsightsStatus;
    private final Instant lastUpdateDateTime;
    private final FailureException failureException;

    private DescribeContributorInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.contributorInsightsRuleList = builder.contributorInsightsRuleList;
        this.contributorInsightsStatus = builder.contributorInsightsStatus;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
        this.failureException = builder.failureException;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final boolean hasContributorInsightsRuleList() {
        return this.contributorInsightsRuleList != null && !(this.contributorInsightsRuleList instanceof SdkAutoConstructList);
    }

    public final List<String> contributorInsightsRuleList() {
        return this.contributorInsightsRuleList;
    }

    public final ContributorInsightsStatus contributorInsightsStatus() {
        return ContributorInsightsStatus.fromValue(this.contributorInsightsStatus);
    }

    public final String contributorInsightsStatusAsString() {
        return this.contributorInsightsStatus;
    }

    public final Instant lastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public final FailureException failureException() {
        return this.failureException;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributorInsightsRuleList() ? this.contributorInsightsRuleList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contributorInsightsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureException());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContributorInsightsResponse)) {
            return false;
        }
        DescribeContributorInsightsResponse other = (DescribeContributorInsightsResponse)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.indexName(), other.indexName()) && this.hasContributorInsightsRuleList() == other.hasContributorInsightsRuleList() && Objects.equals(this.contributorInsightsRuleList(), other.contributorInsightsRuleList()) && Objects.equals(this.contributorInsightsStatusAsString(), other.contributorInsightsStatusAsString()) && Objects.equals(this.lastUpdateDateTime(), other.lastUpdateDateTime()) && Objects.equals(this.failureException(), other.failureException());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeContributorInsightsResponse").add("TableName", (Object)this.tableName()).add("IndexName", (Object)this.indexName()).add("ContributorInsightsRuleList", this.hasContributorInsightsRuleList() ? this.contributorInsightsRuleList() : null).add("ContributorInsightsStatus", (Object)this.contributorInsightsStatusAsString()).add("LastUpdateDateTime", (Object)this.lastUpdateDateTime()).add("FailureException", (Object)this.failureException()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "ContributorInsightsRuleList": {
                return Optional.ofNullable(clazz.cast(this.contributorInsightsRuleList()));
            }
            case "ContributorInsightsStatus": {
                return Optional.ofNullable(clazz.cast(this.contributorInsightsStatusAsString()));
            }
            case "LastUpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDateTime()));
            }
            case "FailureException": {
                return Optional.ofNullable(clazz.cast(this.failureException()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContributorInsightsResponse, T> g) {
        return obj -> g.apply((DescribeContributorInsightsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private String tableName;
        private String indexName;
        private List<String> contributorInsightsRuleList = DefaultSdkAutoConstructList.getInstance();
        private String contributorInsightsStatus;
        private Instant lastUpdateDateTime;
        private FailureException failureException;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContributorInsightsResponse model) {
            super(model);
            this.tableName(model.tableName);
            this.indexName(model.indexName);
            this.contributorInsightsRuleList(model.contributorInsightsRuleList);
            this.contributorInsightsStatus(model.contributorInsightsStatus);
            this.lastUpdateDateTime(model.lastUpdateDateTime);
            this.failureException(model.failureException);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Collection<String> getContributorInsightsRuleList() {
            if (this.contributorInsightsRuleList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contributorInsightsRuleList;
        }

        public final void setContributorInsightsRuleList(Collection<String> contributorInsightsRuleList) {
            this.contributorInsightsRuleList = ContributorInsightsRuleListCopier.copy(contributorInsightsRuleList);
        }

        @Override
        public final Builder contributorInsightsRuleList(Collection<String> contributorInsightsRuleList) {
            this.contributorInsightsRuleList = ContributorInsightsRuleListCopier.copy(contributorInsightsRuleList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorInsightsRuleList(String ... contributorInsightsRuleList) {
            this.contributorInsightsRuleList(Arrays.asList(contributorInsightsRuleList));
            return this;
        }

        public final String getContributorInsightsStatus() {
            return this.contributorInsightsStatus;
        }

        public final void setContributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
        }

        @Override
        public final Builder contributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
            return this;
        }

        @Override
        public final Builder contributorInsightsStatus(ContributorInsightsStatus contributorInsightsStatus) {
            this.contributorInsightsStatus(contributorInsightsStatus == null ? null : contributorInsightsStatus.toString());
            return this;
        }

        public final Instant getLastUpdateDateTime() {
            return this.lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public final FailureException.Builder getFailureException() {
            return this.failureException != null ? this.failureException.toBuilder() : null;
        }

        public final void setFailureException(FailureException.BuilderImpl failureException) {
            this.failureException = failureException != null ? failureException.build() : null;
        }

        @Override
        public final Builder failureException(FailureException failureException) {
            this.failureException = failureException;
            return this;
        }

        @Override
        public DescribeContributorInsightsResponse build() {
            return new DescribeContributorInsightsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeContributorInsightsResponse> {
        public Builder tableName(String var1);

        public Builder indexName(String var1);

        public Builder contributorInsightsRuleList(Collection<String> var1);

        public Builder contributorInsightsRuleList(String ... var1);

        public Builder contributorInsightsStatus(String var1);

        public Builder contributorInsightsStatus(ContributorInsightsStatus var1);

        public Builder lastUpdateDateTime(Instant var1);

        public Builder failureException(FailureException var1);

        default public Builder failureException(Consumer<FailureException.Builder> failureException) {
            return this.failureException((FailureException)((FailureException.Builder)FailureException.builder().applyMutation(failureException)).build());
        }
    }
}

