/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableReplicaAutoScalingResponse extends DynamoDbResponse implements
        ToCopyableBuilder<UpdateTableReplicaAutoScalingResponse.Builder, UpdateTableReplicaAutoScalingResponse> {
    private static final SdkField<TableAutoScalingDescription> TABLE_AUTO_SCALING_DESCRIPTION_FIELD = SdkField
            .<TableAutoScalingDescription> builder(MarshallingType.SDK_POJO)
            .memberName("TableAutoScalingDescription")
            .getter(getter(UpdateTableReplicaAutoScalingResponse::tableAutoScalingDescription))
            .setter(setter(Builder::tableAutoScalingDescription))
            .constructor(TableAutoScalingDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableAutoScalingDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TABLE_AUTO_SCALING_DESCRIPTION_FIELD));

    private final TableAutoScalingDescription tableAutoScalingDescription;

    private UpdateTableReplicaAutoScalingResponse(BuilderImpl builder) {
        super(builder);
        this.tableAutoScalingDescription = builder.tableAutoScalingDescription;
    }

    /**
     * <p>
     * Returns information about the auto scaling settings of a table with replicas.
     * </p>
     * 
     * @return Returns information about the auto scaling settings of a table with replicas.
     */
    public final TableAutoScalingDescription tableAutoScalingDescription() {
        return tableAutoScalingDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableAutoScalingDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableReplicaAutoScalingResponse)) {
            return false;
        }
        UpdateTableReplicaAutoScalingResponse other = (UpdateTableReplicaAutoScalingResponse) obj;
        return Objects.equals(tableAutoScalingDescription(), other.tableAutoScalingDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableReplicaAutoScalingResponse")
                .add("TableAutoScalingDescription", tableAutoScalingDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableAutoScalingDescription":
            return Optional.ofNullable(clazz.cast(tableAutoScalingDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableReplicaAutoScalingResponse, T> g) {
        return obj -> g.apply((UpdateTableReplicaAutoScalingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTableReplicaAutoScalingResponse> {
        /**
         * <p>
         * Returns information about the auto scaling settings of a table with replicas.
         * </p>
         * 
         * @param tableAutoScalingDescription
         *        Returns information about the auto scaling settings of a table with replicas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableAutoScalingDescription(TableAutoScalingDescription tableAutoScalingDescription);

        /**
         * <p>
         * Returns information about the auto scaling settings of a table with replicas.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableAutoScalingDescription.Builder}
         * avoiding the need to create one manually via {@link TableAutoScalingDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableAutoScalingDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #tableAutoScalingDescription(TableAutoScalingDescription)}.
         * 
         * @param tableAutoScalingDescription
         *        a consumer that will call methods on {@link TableAutoScalingDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableAutoScalingDescription(TableAutoScalingDescription)
         */
        default Builder tableAutoScalingDescription(Consumer<TableAutoScalingDescription.Builder> tableAutoScalingDescription) {
            return tableAutoScalingDescription(TableAutoScalingDescription.builder().applyMutation(tableAutoScalingDescription)
                    .build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private TableAutoScalingDescription tableAutoScalingDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableReplicaAutoScalingResponse model) {
            super(model);
            tableAutoScalingDescription(model.tableAutoScalingDescription);
        }

        public final TableAutoScalingDescription.Builder getTableAutoScalingDescription() {
            return tableAutoScalingDescription != null ? tableAutoScalingDescription.toBuilder() : null;
        }

        public final void setTableAutoScalingDescription(TableAutoScalingDescription.BuilderImpl tableAutoScalingDescription) {
            this.tableAutoScalingDescription = tableAutoScalingDescription != null ? tableAutoScalingDescription.build() : null;
        }

        @Override
        public final Builder tableAutoScalingDescription(TableAutoScalingDescription tableAutoScalingDescription) {
            this.tableAutoScalingDescription = tableAutoScalingDescription;
            return this;
        }

        @Override
        public UpdateTableReplicaAutoScalingResponse build() {
            return new UpdateTableReplicaAutoScalingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
