/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.ExportFormat;
import software.amazon.awssdk.services.dynamodb.model.ExportStatus;
import software.amazon.awssdk.services.dynamodb.model.S3SseAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportDescription> {
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportArn").getter(ExportDescription.getter(ExportDescription::exportArn)).setter(ExportDescription.setter(Builder::exportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportStatus").getter(ExportDescription.getter(ExportDescription::exportStatusAsString)).setter(ExportDescription.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ExportDescription.getter(ExportDescription::startTime)).setter(ExportDescription.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ExportDescription.getter(ExportDescription::endTime)).setter(ExportDescription.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> EXPORT_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportManifest").getter(ExportDescription.getter(ExportDescription::exportManifest)).setter(ExportDescription.setter(Builder::exportManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportManifest").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableArn").getter(ExportDescription.getter(ExportDescription::tableArn)).setter(ExportDescription.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableId").getter(ExportDescription.getter(ExportDescription::tableId)).setter(ExportDescription.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()}).build();
    private static final SdkField<Instant> EXPORT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExportTime").getter(ExportDescription.getter(ExportDescription::exportTime)).setter(ExportDescription.setter(Builder::exportTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTime").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ExportDescription.getter(ExportDescription::clientToken)).setter(ExportDescription.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(ExportDescription.getter(ExportDescription::s3Bucket)).setter(ExportDescription.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketOwner").getter(ExportDescription.getter(ExportDescription::s3BucketOwner)).setter(ExportDescription.setter(Builder::s3BucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketOwner").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(ExportDescription.getter(ExportDescription::s3Prefix)).setter(ExportDescription.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<String> S3_SSE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3SseAlgorithm").getter(ExportDescription.getter(ExportDescription::s3SseAlgorithmAsString)).setter(ExportDescription.setter(Builder::s3SseAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseAlgorithm").build()}).build();
    private static final SdkField<String> S3_SSE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3SseKmsKeyId").getter(ExportDescription.getter(ExportDescription::s3SseKmsKeyId)).setter(ExportDescription.setter(Builder::s3SseKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3SseKmsKeyId").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(ExportDescription.getter(ExportDescription::failureCode)).setter(ExportDescription.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(ExportDescription.getter(ExportDescription::failureMessage)).setter(ExportDescription.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<String> EXPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportFormat").getter(ExportDescription.getter(ExportDescription::exportFormatAsString)).setter(ExportDescription.setter(Builder::exportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportFormat").build()}).build();
    private static final SdkField<Long> BILLED_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BilledSizeBytes").getter(ExportDescription.getter(ExportDescription::billedSizeBytes)).setter(ExportDescription.setter(Builder::billedSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BilledSizeBytes").build()}).build();
    private static final SdkField<Long> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ItemCount").getter(ExportDescription.getter(ExportDescription::itemCount)).setter(ExportDescription.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ARN_FIELD, EXPORT_STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, EXPORT_MANIFEST_FIELD, TABLE_ARN_FIELD, TABLE_ID_FIELD, EXPORT_TIME_FIELD, CLIENT_TOKEN_FIELD, S3_BUCKET_FIELD, S3_BUCKET_OWNER_FIELD, S3_PREFIX_FIELD, S3_SSE_ALGORITHM_FIELD, S3_SSE_KMS_KEY_ID_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD, EXPORT_FORMAT_FIELD, BILLED_SIZE_BYTES_FIELD, ITEM_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String exportArn;
    private final String exportStatus;
    private final Instant startTime;
    private final Instant endTime;
    private final String exportManifest;
    private final String tableArn;
    private final String tableId;
    private final Instant exportTime;
    private final String clientToken;
    private final String s3Bucket;
    private final String s3BucketOwner;
    private final String s3Prefix;
    private final String s3SseAlgorithm;
    private final String s3SseKmsKeyId;
    private final String failureCode;
    private final String failureMessage;
    private final String exportFormat;
    private final Long billedSizeBytes;
    private final Long itemCount;

    private ExportDescription(BuilderImpl builder) {
        this.exportArn = builder.exportArn;
        this.exportStatus = builder.exportStatus;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.exportManifest = builder.exportManifest;
        this.tableArn = builder.tableArn;
        this.tableId = builder.tableId;
        this.exportTime = builder.exportTime;
        this.clientToken = builder.clientToken;
        this.s3Bucket = builder.s3Bucket;
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Prefix = builder.s3Prefix;
        this.s3SseAlgorithm = builder.s3SseAlgorithm;
        this.s3SseKmsKeyId = builder.s3SseKmsKeyId;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.exportFormat = builder.exportFormat;
        this.billedSizeBytes = builder.billedSizeBytes;
        this.itemCount = builder.itemCount;
    }

    public final String exportArn() {
        return this.exportArn;
    }

    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String exportManifest() {
        return this.exportManifest;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final Instant exportTime() {
        return this.exportTime;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3BucketOwner() {
        return this.s3BucketOwner;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final S3SseAlgorithm s3SseAlgorithm() {
        return S3SseAlgorithm.fromValue(this.s3SseAlgorithm);
    }

    public final String s3SseAlgorithmAsString() {
        return this.s3SseAlgorithm;
    }

    public final String s3SseKmsKeyId() {
        return this.s3SseKmsKeyId;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final ExportFormat exportFormat() {
        return ExportFormat.fromValue(this.exportFormat);
    }

    public final String exportFormatAsString() {
        return this.exportFormat;
    }

    public final Long billedSizeBytes() {
        return this.billedSizeBytes;
    }

    public final Long itemCount() {
        return this.itemCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exportArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3SseAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3SseKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.billedSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportDescription)) {
            return false;
        }
        ExportDescription other = (ExportDescription)obj;
        return Objects.equals(this.exportArn(), other.exportArn()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.exportManifest(), other.exportManifest()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.tableId(), other.tableId()) && Objects.equals(this.exportTime(), other.exportTime()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3BucketOwner(), other.s3BucketOwner()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3SseAlgorithmAsString(), other.s3SseAlgorithmAsString()) && Objects.equals(this.s3SseKmsKeyId(), other.s3SseKmsKeyId()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.exportFormatAsString(), other.exportFormatAsString()) && Objects.equals(this.billedSizeBytes(), other.billedSizeBytes()) && Objects.equals(this.itemCount(), other.itemCount());
    }

    public final String toString() {
        return ToString.builder((String)"ExportDescription").add("ExportArn", (Object)this.exportArn()).add("ExportStatus", (Object)this.exportStatusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ExportManifest", (Object)this.exportManifest()).add("TableArn", (Object)this.tableArn()).add("TableId", (Object)this.tableId()).add("ExportTime", (Object)this.exportTime()).add("ClientToken", (Object)this.clientToken()).add("S3Bucket", (Object)this.s3Bucket()).add("S3BucketOwner", (Object)this.s3BucketOwner()).add("S3Prefix", (Object)this.s3Prefix()).add("S3SseAlgorithm", (Object)this.s3SseAlgorithmAsString()).add("S3SseKmsKeyId", (Object)this.s3SseKmsKeyId()).add("FailureCode", (Object)this.failureCode()).add("FailureMessage", (Object)this.failureMessage()).add("ExportFormat", (Object)this.exportFormatAsString()).add("BilledSizeBytes", (Object)this.billedSizeBytes()).add("ItemCount", (Object)this.itemCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportArn": {
                return Optional.ofNullable(clazz.cast(this.exportArn()));
            }
            case "ExportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ExportManifest": {
                return Optional.ofNullable(clazz.cast(this.exportManifest()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "TableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "ExportTime": {
                return Optional.ofNullable(clazz.cast(this.exportTime()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.s3BucketOwner()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3SseAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.s3SseAlgorithmAsString()));
            }
            case "S3SseKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.s3SseKmsKeyId()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "ExportFormat": {
                return Optional.ofNullable(clazz.cast(this.exportFormatAsString()));
            }
            case "BilledSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.billedSizeBytes()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportDescription, T> g) {
        return obj -> g.apply((ExportDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exportArn;
        private String exportStatus;
        private Instant startTime;
        private Instant endTime;
        private String exportManifest;
        private String tableArn;
        private String tableId;
        private Instant exportTime;
        private String clientToken;
        private String s3Bucket;
        private String s3BucketOwner;
        private String s3Prefix;
        private String s3SseAlgorithm;
        private String s3SseKmsKeyId;
        private String failureCode;
        private String failureMessage;
        private String exportFormat;
        private Long billedSizeBytes;
        private Long itemCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportDescription model) {
            this.exportArn(model.exportArn);
            this.exportStatus(model.exportStatus);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.exportManifest(model.exportManifest);
            this.tableArn(model.tableArn);
            this.tableId(model.tableId);
            this.exportTime(model.exportTime);
            this.clientToken(model.clientToken);
            this.s3Bucket(model.s3Bucket);
            this.s3BucketOwner(model.s3BucketOwner);
            this.s3Prefix(model.s3Prefix);
            this.s3SseAlgorithm(model.s3SseAlgorithm);
            this.s3SseKmsKeyId(model.s3SseKmsKeyId);
            this.failureCode(model.failureCode);
            this.failureMessage(model.failureMessage);
            this.exportFormat(model.exportFormat);
            this.billedSizeBytes(model.billedSizeBytes);
            this.itemCount(model.itemCount);
        }

        public final String getExportArn() {
            return this.exportArn;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        @Override
        @Transient
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        @Transient
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getExportManifest() {
            return this.exportManifest;
        }

        public final void setExportManifest(String exportManifest) {
            this.exportManifest = exportManifest;
        }

        @Override
        @Transient
        public final Builder exportManifest(String exportManifest) {
            this.exportManifest = exportManifest;
            return this;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        @Transient
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final String getTableId() {
            return this.tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        @Transient
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final Instant getExportTime() {
            return this.exportTime;
        }

        public final void setExportTime(Instant exportTime) {
            this.exportTime = exportTime;
        }

        @Override
        @Transient
        public final Builder exportTime(Instant exportTime) {
            this.exportTime = exportTime;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        @Transient
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3BucketOwner() {
            return this.s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        @Transient
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        @Transient
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3SseAlgorithm() {
            return this.s3SseAlgorithm;
        }

        public final void setS3SseAlgorithm(String s3SseAlgorithm) {
            this.s3SseAlgorithm = s3SseAlgorithm;
        }

        @Override
        @Transient
        public final Builder s3SseAlgorithm(String s3SseAlgorithm) {
            this.s3SseAlgorithm = s3SseAlgorithm;
            return this;
        }

        @Override
        @Transient
        public final Builder s3SseAlgorithm(S3SseAlgorithm s3SseAlgorithm) {
            this.s3SseAlgorithm(s3SseAlgorithm == null ? null : s3SseAlgorithm.toString());
            return this;
        }

        public final String getS3SseKmsKeyId() {
            return this.s3SseKmsKeyId;
        }

        public final void setS3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
        }

        @Override
        @Transient
        public final Builder s3SseKmsKeyId(String s3SseKmsKeyId) {
            this.s3SseKmsKeyId = s3SseKmsKeyId;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        @Transient
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        @Transient
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getExportFormat() {
            return this.exportFormat;
        }

        public final void setExportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
        }

        @Override
        @Transient
        public final Builder exportFormat(String exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder exportFormat(ExportFormat exportFormat) {
            this.exportFormat(exportFormat == null ? null : exportFormat.toString());
            return this;
        }

        public final Long getBilledSizeBytes() {
            return this.billedSizeBytes;
        }

        public final void setBilledSizeBytes(Long billedSizeBytes) {
            this.billedSizeBytes = billedSizeBytes;
        }

        @Override
        @Transient
        public final Builder billedSizeBytes(Long billedSizeBytes) {
            this.billedSizeBytes = billedSizeBytes;
            return this;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        @Transient
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public ExportDescription build() {
            return new ExportDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportDescription> {
        public Builder exportArn(String var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(ExportStatus var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder exportManifest(String var1);

        public Builder tableArn(String var1);

        public Builder tableId(String var1);

        public Builder exportTime(Instant var1);

        public Builder clientToken(String var1);

        public Builder s3Bucket(String var1);

        public Builder s3BucketOwner(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3SseAlgorithm(String var1);

        public Builder s3SseAlgorithm(S3SseAlgorithm var1);

        public Builder s3SseKmsKeyId(String var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);

        public Builder exportFormat(String var1);

        public Builder exportFormat(ExportFormat var1);

        public Builder billedSizeBytes(Long var1);

        public Builder itemCount(Long var1);
    }
}

