/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the
 * <code>UpdateTable</code> operation.
 * </p>
 * <p>
 * For current minimum and maximum provisioned throughput values, see <a
 * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
 * Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedThroughput implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedThroughput.Builder, ProvisionedThroughput> {
    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ReadCapacityUnits").getter(getter(ProvisionedThroughput::readCapacityUnits))
            .setter(setter(Builder::readCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCapacityUnits").build()).build();

    private static final SdkField<Long> WRITE_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WriteCapacityUnits").getter(getter(ProvisionedThroughput::writeCapacityUnits))
            .setter(setter(Builder::writeCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCapacityUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_CAPACITY_UNITS_FIELD,
            WRITE_CAPACITY_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long readCapacityUnits;

    private final Long writeCapacityUnits;

    private ProvisionedThroughput(BuilderImpl builder) {
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     *         >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
     *         <p>
     *         If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
     */
    public final Long readCapacityUnits() {
        return readCapacityUnits;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
     *         >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
     *         <p>
     *         If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
     */
    public final Long writeCapacityUnits() {
        return writeCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(writeCapacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughput)) {
            return false;
        }
        ProvisionedThroughput other = (ProvisionedThroughput) obj;
        return Objects.equals(readCapacityUnits(), other.readCapacityUnits())
                && Objects.equals(writeCapacityUnits(), other.writeCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedThroughput").add("ReadCapacityUnits", readCapacityUnits())
                .add("WriteCapacityUnits", writeCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(readCapacityUnits()));
        case "WriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(writeCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedThroughput, T> g) {
        return obj -> g.apply((ProvisionedThroughput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedThroughput> {
        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
         * </p>
         * 
         * @param readCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         *        >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Long readCapacityUnits);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         * >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
         * </p>
         * 
         * @param writeCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput"
         *        >Specifying Read and Write Requirements</a> in the <i>Amazon DynamoDB Developer Guide</i>.</p>
         *        <p>
         *        If read/write capacity mode is <code>PAY_PER_REQUEST</code> the value is set to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCapacityUnits(Long writeCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private Long readCapacityUnits;

        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughput model) {
            readCapacityUnits(model.readCapacityUnits);
            writeCapacityUnits(model.writeCapacityUnits);
        }

        public final Long getReadCapacityUnits() {
            return readCapacityUnits;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        @Transient
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final Long getWriteCapacityUnits() {
            return writeCapacityUnits;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        @Transient
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        @Override
        public ProvisionedThroughput build() {
            return new ProvisionedThroughput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
