/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.BatchGetRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetItemRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, BatchGetItemRequest> {
    private static final SdkField<Map<String, KeysAndAttributes>> REQUEST_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RequestItems").getter(BatchGetItemRequest.getter(BatchGetItemRequest::requestItems)).setter(BatchGetItemRequest.setter(Builder::requestItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeysAndAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnConsumedCapacity").getter(BatchGetItemRequest.getter(BatchGetItemRequest::returnConsumedCapacityAsString)).setter(BatchGetItemRequest.setter(Builder::returnConsumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ITEMS_FIELD, RETURN_CONSUMED_CAPACITY_FIELD));
    private final Map<String, KeysAndAttributes> requestItems;
    private final String returnConsumedCapacity;

    private BatchGetItemRequest(BuilderImpl builder) {
        super(builder);
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    public boolean hasRequestItems() {
        return this.requestItems != null && !(this.requestItems instanceof SdkAutoConstructMap);
    }

    public Map<String, KeysAndAttributes> requestItems() {
        return this.requestItems;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestItems() ? this.requestItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemRequest)) {
            return false;
        }
        BatchGetItemRequest other = (BatchGetItemRequest)((Object)obj);
        return this.hasRequestItems() == other.hasRequestItems() && Objects.equals(this.requestItems(), other.requestItems()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetItemRequest").add("RequestItems", this.hasRequestItems() ? this.requestItems() : null).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestItems": {
                return Optional.ofNullable(clazz.cast(this.requestItems()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.returnConsumedCapacityAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetItemRequest, T> g) {
        return obj -> g.apply((BatchGetItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private Map<String, KeysAndAttributes> requestItems = DefaultSdkAutoConstructMap.getInstance();
        private String returnConsumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemRequest model) {
            super(model);
            this.requestItems(model.requestItems);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
        }

        public final Map<String, KeysAndAttributes.Builder> getRequestItems() {
            if (this.requestItems instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestItems != null ? CollectionUtils.mapValues(this.requestItems, KeysAndAttributes::toBuilder) : null;
        }

        @Override
        public final Builder requestItems(Map<String, KeysAndAttributes> requestItems) {
            this.requestItems = BatchGetRequestMapCopier.copy(requestItems);
            return this;
        }

        public final void setRequestItems(Map<String, KeysAndAttributes.BuilderImpl> requestItems) {
            this.requestItems = BatchGetRequestMapCopier.copyFromBuilder(requestItems);
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetItemRequest build() {
            return new BatchGetItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetItemRequest> {
        public Builder requestItems(Map<String, KeysAndAttributes> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

