/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalSecondaryIndexDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalSecondaryIndexDescription> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::indexName)).setter(GlobalSecondaryIndexDescription.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::keySchema)).setter(GlobalSecondaryIndexDescription.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeySchemaElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Projection> PROJECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::projection)).setter(GlobalSecondaryIndexDescription.setter(Builder::projection)).constructor(Projection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Projection").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::indexStatusAsString)).setter(GlobalSecondaryIndexDescription.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<Boolean> BACKFILLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::backfilling)).setter(GlobalSecondaryIndexDescription.setter(Builder::backfilling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backfilling").build()}).build();
    private static final SdkField<ProvisionedThroughputDescription> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::provisionedThroughput)).setter(GlobalSecondaryIndexDescription.setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final SdkField<Long> INDEX_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::indexSizeBytes)).setter(GlobalSecondaryIndexDescription.setter(Builder::indexSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexSizeBytes").build()}).build();
    private static final SdkField<Long> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::itemCount)).setter(GlobalSecondaryIndexDescription.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GlobalSecondaryIndexDescription.getter(GlobalSecondaryIndexDescription::indexArn)).setter(GlobalSecondaryIndexDescription.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, KEY_SCHEMA_FIELD, PROJECTION_FIELD, INDEX_STATUS_FIELD, BACKFILLING_FIELD, PROVISIONED_THROUGHPUT_FIELD, INDEX_SIZE_BYTES_FIELD, ITEM_COUNT_FIELD, INDEX_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final List<KeySchemaElement> keySchema;
    private final Projection projection;
    private final String indexStatus;
    private final Boolean backfilling;
    private final ProvisionedThroughputDescription provisionedThroughput;
    private final Long indexSizeBytes;
    private final Long itemCount;
    private final String indexArn;

    private GlobalSecondaryIndexDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.indexStatus = builder.indexStatus;
        this.backfilling = builder.backfilling;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.indexSizeBytes = builder.indexSizeBytes;
        this.itemCount = builder.itemCount;
        this.indexArn = builder.indexArn;
    }

    public String indexName() {
        return this.indexName;
    }

    public boolean hasKeySchema() {
        return this.keySchema != null && !(this.keySchema instanceof SdkAutoConstructList);
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public Projection projection() {
        return this.projection;
    }

    public IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public String indexStatusAsString() {
        return this.indexStatus;
    }

    public Boolean backfilling() {
        return this.backfilling;
    }

    public ProvisionedThroughputDescription provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Long indexSizeBytes() {
        return this.indexSizeBytes;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public String indexArn() {
        return this.indexArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.projection());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backfilling());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexDescription)) {
            return false;
        }
        GlobalSecondaryIndexDescription other = (GlobalSecondaryIndexDescription)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.projection(), other.projection()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.backfilling(), other.backfilling()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.indexSizeBytes(), other.indexSizeBytes()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.indexArn(), other.indexArn());
    }

    public String toString() {
        return ToString.builder((String)"GlobalSecondaryIndexDescription").add("IndexName", (Object)this.indexName()).add("KeySchema", this.keySchema()).add("Projection", (Object)this.projection()).add("IndexStatus", (Object)this.indexStatusAsString()).add("Backfilling", (Object)this.backfilling()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("IndexSizeBytes", (Object)this.indexSizeBytes()).add("ItemCount", (Object)this.itemCount()).add("IndexArn", (Object)this.indexArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "Projection": {
                return Optional.ofNullable(clazz.cast(this.projection()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "Backfilling": {
                return Optional.ofNullable(clazz.cast(this.backfilling()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "IndexSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.indexSizeBytes()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "IndexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalSecondaryIndexDescription, T> g) {
        return obj -> g.apply((GlobalSecondaryIndexDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private Projection projection;
        private String indexStatus;
        private Boolean backfilling;
        private ProvisionedThroughputDescription provisionedThroughput;
        private Long indexSizeBytes;
        private Long itemCount;
        private String indexArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndexDescription model) {
            this.indexName(model.indexName);
            this.keySchema(model.keySchema);
            this.projection(model.projection);
            this.indexStatus(model.indexStatus);
            this.backfilling(model.backfilling);
            this.provisionedThroughput(model.provisionedThroughput);
            this.indexSizeBytes(model.indexSizeBytes);
            this.itemCount(model.itemCount);
            this.indexArn(model.indexArn);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Projection.Builder getProjection() {
            return this.projection != null ? this.projection.toBuilder() : null;
        }

        @Override
        public final Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public final void setProjection(Projection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final Boolean getBackfilling() {
            return this.backfilling;
        }

        @Override
        public final Builder backfilling(Boolean backfilling) {
            this.backfilling = backfilling;
            return this;
        }

        public final void setBackfilling(Boolean backfilling) {
            this.backfilling = backfilling;
        }

        public final ProvisionedThroughputDescription.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughputDescription.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Long getIndexSizeBytes() {
            return this.indexSizeBytes;
        }

        @Override
        public final Builder indexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
            return this;
        }

        public final void setIndexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        public GlobalSecondaryIndexDescription build() {
            return new GlobalSecondaryIndexDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalSecondaryIndexDescription> {
        public Builder indexName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder projection(Projection var1);

        default public Builder projection(Consumer<Projection.Builder> projection) {
            return this.projection((Projection)((Projection.Builder)Projection.builder().applyMutation(projection)).build());
        }

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder backfilling(Boolean var1);

        public Builder provisionedThroughput(ProvisionedThroughputDescription var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughputDescription.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughputDescription)((ProvisionedThroughputDescription.Builder)ProvisionedThroughputDescription.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder indexSizeBytes(Long var1);

        public Builder itemCount(Long var1);

        public Builder indexArn(String var1);
    }
}

