/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>Query</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryRequest extends DynamoDbRequest implements ToCopyableBuilder<QueryRequest.Builder, QueryRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> SELECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryRequest::selectAsString)).setter(setter(Builder::select))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Select").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(QueryRequest::attributesToGet))
            .setter(setter(Builder::attributesToGet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(QueryRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<Boolean> CONSISTENT_READ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(QueryRequest::consistentRead)).setter(setter(Builder::consistentRead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistentRead").build()).build();

    private static final SdkField<Map<String, Condition>> KEY_CONDITIONS_FIELD = SdkField
            .<Map<String, Condition>> builder(MarshallingType.MAP)
            .getter(getter(QueryRequest::keyConditions))
            .setter(setter(Builder::keyConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyConditions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Condition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Condition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Condition>> QUERY_FILTER_FIELD = SdkField
            .<Map<String, Condition>> builder(MarshallingType.MAP)
            .getter(getter(QueryRequest::queryFilter))
            .setter(setter(Builder::queryFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryFilter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Condition> builder(MarshallingType.SDK_POJO)
                                            .constructor(Condition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONDITIONAL_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryRequest::conditionalOperatorAsString)).setter(setter(Builder::conditionalOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalOperator").build())
            .build();

    private static final SdkField<Boolean> SCAN_INDEX_FORWARD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(QueryRequest::scanIndexForward)).setter(setter(Builder::scanIndexForward))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanIndexForward").build()).build();

    private static final SdkField<Map<String, AttributeValue>> EXCLUSIVE_START_KEY_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(QueryRequest::exclusiveStartKey))
            .setter(setter(Builder::exclusiveStartKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartKey").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryRequest::returnConsumedCapacityAsString)).setter(setter(Builder::returnConsumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build())
            .build();

    private static final SdkField<String> PROJECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryRequest::projectionExpression)).setter(setter(Builder::projectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionExpression").build())
            .build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryRequest::filterExpression)).setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final SdkField<String> KEY_CONDITION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryRequest::keyConditionExpression)).setter(setter(Builder::keyConditionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyConditionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(QueryRequest::expressionAttributeNames))
            .setter(setter(Builder::expressionAttributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(QueryRequest::expressionAttributeValues))
            .setter(setter(Builder::expressionAttributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            INDEX_NAME_FIELD, SELECT_FIELD, ATTRIBUTES_TO_GET_FIELD, LIMIT_FIELD, CONSISTENT_READ_FIELD, KEY_CONDITIONS_FIELD,
            QUERY_FILTER_FIELD, CONDITIONAL_OPERATOR_FIELD, SCAN_INDEX_FORWARD_FIELD, EXCLUSIVE_START_KEY_FIELD,
            RETURN_CONSUMED_CAPACITY_FIELD, PROJECTION_EXPRESSION_FIELD, FILTER_EXPRESSION_FIELD, KEY_CONDITION_EXPRESSION_FIELD,
            EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD));

    private final String tableName;

    private final String indexName;

    private final String select;

    private final List<String> attributesToGet;

    private final Integer limit;

    private final Boolean consistentRead;

    private final Map<String, Condition> keyConditions;

    private final Map<String, Condition> queryFilter;

    private final String conditionalOperator;

    private final Boolean scanIndexForward;

    private final Map<String, AttributeValue> exclusiveStartKey;

    private final String returnConsumedCapacity;

    private final String projectionExpression;

    private final String filterExpression;

    private final String keyConditionExpression;

    private final Map<String, String> expressionAttributeNames;

    private final Map<String, AttributeValue> expressionAttributeValues;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.select = builder.select;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.keyConditions = builder.keyConditions;
        this.queryFilter = builder.queryFilter;
        this.conditionalOperator = builder.conditionalOperator;
        this.scanIndexForward = builder.scanIndexForward;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.projectionExpression = builder.projectionExpression;
        this.filterExpression = builder.filterExpression;
        this.keyConditionExpression = builder.keyConditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    /**
     * <p>
     * The name of the table containing the requested items.
     * </p>
     * 
     * @return The name of the table containing the requested items.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of an index to query. This index can be any local secondary index or global secondary index on the
     * table. Note that if you use the <code>IndexName</code> parameter, you must also provide <code>TableName.</code>
     * </p>
     * 
     * @return The name of an index to query. This index can be any local secondary index or global secondary index on
     *         the table. Note that if you use the <code>IndexName</code> parameter, you must also provide
     *         <code>TableName.</code>
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the
     * count of matching items, or in the case of an index, some or all of the attributes projected into the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query
     * a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the
     * parent table. If the index is configured to project all item attributes, then all of the data can be obtained
     * from the local secondary index, and no fetching is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have
     * been projected into the index. If the index is configured to project all attributes, this return value is
     * equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
     * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
     * <code>Select</code>.
     * </p>
     * <p>
     * If you query or scan a local secondary index and request only attributes that are projected into that index, the
     * operation will read only the index and not the table. If any of the requested attributes are not projected into
     * the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching
     * incurs additional throughput cost and latency.
     * </p>
     * <p>
     * If you query or scan a global secondary index, you can only request attributes that are projected into the index.
     * Global secondary index queries cannot fetch attributes from the parent table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an
     * index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request,
     * unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to
     * specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
     * </p>
     * <note>
     * <p>
     * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be
     * <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #select} will
     * return {@link Select#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectAsString}.
     * </p>
     * 
     * @return The attributes to be returned in the result. You can retrieve all item attributes, specific item
     *         attributes, the count of matching items, or in the case of an index, some or all of the attributes
     *         projected into the index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
     *         you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire
     *         item from the parent table. If the index is configured to project all item attributes, then all of the
     *         data can be obtained from the local secondary index, and no fetching is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
     *         that have been projected into the index. If the index is configured to project all attributes, this
     *         return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
     *         This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value
     *         for <code>Select</code>.
     *         </p>
     *         <p>
     *         If you query or scan a local secondary index and request only attributes that are projected into that
     *         index, the operation will read only the index and not the table. If any of the requested attributes are
     *         not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent
     *         table. This extra fetching incurs additional throughput cost and latency.
     *         </p>
     *         <p>
     *         If you query or scan a global secondary index, you can only request attributes that are projected into
     *         the index. Global secondary index queries cannot fetch attributes from the parent table.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     *         <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
     *         accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in
     *         a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
     *         usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>
     *         .)
     *         </p>
     *         <note>
     *         <p>
     *         If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
     *         only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     *         </p>
     * @see Select
     */
    public Select select() {
        return Select.fromValue(select);
    }

    /**
     * <p>
     * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the
     * count of matching items, or in the case of an index, some or all of the attributes projected into the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you query
     * a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the
     * parent table. If the index is configured to project all item attributes, then all of the data can be obtained
     * from the local secondary index, and no fetching is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that have
     * been projected into the index. If the index is configured to project all attributes, this return value is
     * equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
     * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
     * <code>Select</code>.
     * </p>
     * <p>
     * If you query or scan a local secondary index and request only attributes that are projected into that index, the
     * operation will read only the index and not the table. If any of the requested attributes are not projected into
     * the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching
     * incurs additional throughput cost and latency.
     * </p>
     * <p>
     * If you query or scan a global secondary index, you can only request attributes that are projected into the index.
     * Global secondary index queries cannot fetch attributes from the parent table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing an
     * index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single request,
     * unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is equivalent to
     * specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
     * </p>
     * <note>
     * <p>
     * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only be
     * <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #select} will
     * return {@link Select#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectAsString}.
     * </p>
     * 
     * @return The attributes to be returned in the result. You can retrieve all item attributes, specific item
     *         attributes, the count of matching items, or in the case of an index, some or all of the attributes
     *         projected into the index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
     *         you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire
     *         item from the parent table. If the index is configured to project all item attributes, then all of the
     *         data can be obtained from the local secondary index, and no fetching is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
     *         that have been projected into the index. If the index is configured to project all attributes, this
     *         return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
     *         This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value
     *         for <code>Select</code>.
     *         </p>
     *         <p>
     *         If you query or scan a local secondary index and request only attributes that are projected into that
     *         index, the operation will read only the index and not the table. If any of the requested attributes are
     *         not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent
     *         table. This extra fetching incurs additional throughput cost and latency.
     *         </p>
     *         <p>
     *         If you query or scan a global secondary index, you can only request attributes that are projected into
     *         the index. Global secondary index queries cannot fetch attributes from the parent table.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
     *         <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
     *         accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in
     *         a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This
     *         usage is equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>
     *         .)
     *         </p>
     *         <note>
     *         <p>
     *         If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
     *         only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
     *         </p>
     * @see Select
     */
    public String selectAsString() {
        return select;
    }

    /**
     * Returns true if the AttributesToGet property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttributesToGet() {
        return attributesToGet != null && !(attributesToGet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
     * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributesToGet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
     *         >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public List<String> attributesToGet() {
        return attributesToGet;
    }

    /**
     * <p>
     * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the
     * number of items up to the limit while processing the results, it stops the operation and returns the matching
     * values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation, so that
     * you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this
     * limit, it stops the operation and returns the matching values up to the limit, and a key in
     * <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For more information,
     * see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
     * Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB
     *         processes the number of items up to the limit while processing the results, it stops the operation and
     *         returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a
     *         subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size
     *         exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values
     *         up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to
     *         continue the operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
     *         Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly consistent
     * reads; otherwise, the operation uses eventually consistent reads.
     * </p>
     * <p>
     * Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary index
     * with <code>ConsistentRead</code> set to <code>true</code>, you will receive a <code>ValidationException</code>.
     * </p>
     * 
     * @return Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly
     *         consistent reads; otherwise, the operation uses eventually consistent reads.</p>
     *         <p>
     *         Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary
     *         index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a
     *         <code>ValidationException</code>.
     */
    public Boolean consistentRead() {
        return consistentRead;
    }

    /**
     * Returns true if the KeyConditions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyConditions() {
        return keyConditions != null && !(keyConditions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html"
     * >KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyConditions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html"
     *         >KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, Condition> keyConditions() {
        return keyConditions;
    }

    /**
     * Returns true if the QueryFilter property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasQueryFilter() {
        return queryFilter != null && !(queryFilter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html"
     * >QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueryFilter()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html"
     *         >QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, Condition> queryFilter() {
        return queryFilter;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conditionalOperator} will return {@link ConditionalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conditionalOperatorAsString}.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(conditionalOperator);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conditionalOperator} will return {@link ConditionalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conditionalOperatorAsString}.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public String conditionalOperatorAsString() {
        return conditionalOperator;
    }

    /**
     * <p>
     * Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in ascending
     * order; if <code>false</code>, the traversal is performed in descending order.
     * </p>
     * <p>
     * Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is
     * Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes.
     * For type Binary, DynamoDB treats each byte of the binary data as unsigned.
     * </p>
     * <p>
     * If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which they
     * are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is
     * <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the results
     * to the client.
     * </p>
     * 
     * @return Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in
     *         ascending order; if <code>false</code>, the traversal is performed in descending order. </p>
     *         <p>
     *         Items with the same partition key value are stored in sorted order by sort key. If the sort key data type
     *         is Number, the results are stored in numeric order. For type String, the results are stored in order of
     *         UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.
     *         </p>
     *         <p>
     *         If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which
     *         they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is
     *         <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the
     *         results to the client.
     */
    public Boolean scanIndexForward() {
        return scanIndexForward;
    }

    /**
     * Returns true if the ExclusiveStartKey property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExclusiveStartKey() {
        return exclusiveStartKey != null && !(exclusiveStartKey instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The primary key of the first item that this operation will evaluate. Use the value that was returned for
     * <code>LastEvaluatedKey</code> in the previous operation.
     * </p>
     * <p>
     * The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No set data types are
     * allowed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExclusiveStartKey()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The primary key of the first item that this operation will evaluate. Use the value that was returned for
     *         <code>LastEvaluatedKey</code> in the previous operation.</p>
     *         <p>
     *         The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No set data types are
     *         allowed.
     */
    public Map<String, AttributeValue> exclusiveStartKey() {
        return exclusiveStartKey;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars,
     * sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
     * </p>
     * <p>
     * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are
     * not found, they will not appear in the result.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A string that identifies one or more attributes to retrieve from the table. These attributes can include
     *         scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by
     *         commas.</p>
     *         <p>
     *         If no attribute names are specified, then all attributes will be returned. If any of the requested
     *         attributes are not found, they will not appear in the result.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String projectionExpression() {
        return projectionExpression;
    }

    /**
     * <p>
     * A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but before the
     * data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not returned.
     * </p>
     * <p>
     * A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression based on a
     * partition key or a sort key.
     * </p>
     * <note>
     * <p>
     * A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering does
     * not consume any additional read capacity units.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults">Filter
     * Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but
     *         before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria
     *         are not returned.</p>
     *         <p>
     *         A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression
     *         based on a partition key or a sort key.
     *         </p>
     *         <note>
     *         <p>
     *         A <code>FilterExpression</code> is applied after the items have already been read; the process of
     *         filtering does not consume any additional read capacity units.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
     *         >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * The condition that specifies the key values for items to be retrieved by the <code>Query</code> action.
     * </p>
     * <p>
     * The condition must perform an equality test on a single partition key value.
     * </p>
     * <p>
     * The condition can optionally perform one of several comparison tests on a single sort key value. This allows
     * <code>Query</code> to retrieve one item with a given partition key value and sort key value, or several items
     * that have the same partition key value but different sort key values.
     * </p>
     * <p>
     * The partition key equality test is required, and must be specified in the following format:
     * </p>
     * <p>
     * <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code>
     * </p>
     * <p>
     * If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the
     * condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:
     * </p>
     * <p>
     * <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code>
     * <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code>
     * </p>
     * <p>
     * Valid comparisons for the sort key condition are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to
     * <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less than
     * <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less than or
     * equal to <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is greater than
     * <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is greater
     * than or equal to <code>:sortkeyval</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code>
     * <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to <code>:sortkeyval1</code>, and
     * less than or equal to <code>:sortkeyval2</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if the sort
     * key value begins with a particular operand. (You cannot use this function with a sort key that is of type
     * Number.) Note that the function name <code>begins_with</code> is case-sensitive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as <code>:partitionval</code> and
     * <code>:sortval</code> with actual values at runtime.
     * </p>
     * <p>
     * You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the partition
     * key and sort key with placeholder tokens. This option might be necessary if an attribute name conflicts with a
     * DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code> parameter causes an error
     * because <i>Size</i> is a reserved word:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Size = :myval</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name <i>Size</i>.
     * <code>KeyConditionExpression</code> then is as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#S = :myval</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For a list of reserved words, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
     * Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The condition that specifies the key values for items to be retrieved by the <code>Query</code>
     *         action.</p>
     *         <p>
     *         The condition must perform an equality test on a single partition key value.
     *         </p>
     *         <p>
     *         The condition can optionally perform one of several comparison tests on a single sort key value. This
     *         allows <code>Query</code> to retrieve one item with a given partition key value and sort key value, or
     *         several items that have the same partition key value but different sort key values.
     *         </p>
     *         <p>
     *         The partition key equality test is required, and must be specified in the following format:
     *         </p>
     *         <p>
     *         <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code>
     *         </p>
     *         <p>
     *         If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with
     *         the condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the
     *         sort key:
     *         </p>
     *         <p>
     *         <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code>
     *         <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code>
     *         </p>
     *         <p>
     *         Valid comparisons for the sort key condition are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to
     *         <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less
     *         than <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less
     *         than or equal to <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is
     *         greater than <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is
     *         greater than or equal to <code>:sortkeyval</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code>
     *         <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to
     *         <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if
     *         the sort key value begins with a particular operand. (You cannot use this function with a sort key that
     *         is of type Number.) Note that the function name <code>begins_with</code> is case-sensitive.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
     *         <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.
     *         </p>
     *         <p>
     *         You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the
     *         partition key and sort key with placeholder tokens. This option might be necessary if an attribute name
     *         conflicts with a DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code>
     *         parameter causes an error because <i>Size</i> is a reserved word:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Size = :myval</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name
     *         <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#S = :myval</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For a list of reserved words, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     *         </p>
     *         <p>
     *         For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>,
     *         see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
     *         Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String keyConditionExpression() {
        return keyConditionExpression;
    }

    /**
     * Returns true if the ExpressionAttributeNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExpressionAttributeNames() {
        return expressionAttributeNames != null && !(expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To access an attribute whose name conflicts with a DynamoDB reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a placeholder for repeating occurrences of an attribute name in an expression.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent special characters in an attribute name from being misinterpreted in an expression.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following
     * attribute name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Percentile</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For
     * the complete list of reserved words, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>{"#P":"Percentile"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You could then use this substitution in an expression, as in this example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#P = :val</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for
     * the actual value at runtime.
     * </p>
     * </note>
     * <p>
     * For more information on expression attribute names, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpressionAttributeNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression. The following are some use cases
     *         for using <code>ExpressionAttributeNames</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To access an attribute whose name conflicts with a DynamoDB reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a placeholder for repeating occurrences of an attribute name in an expression.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent special characters in an attribute name from being misinterpreted in an expression.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
     *         following attribute name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Percentile</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
     *         expression. (For the complete list of reserved words, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
     *         following for <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>{"#P":"Percentile"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You could then use this substitution in an expression, as in this example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#P = :val</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
     *         placeholders for the actual value at runtime.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on expression attribute names, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    /**
     * Returns true if the ExpressionAttributeValues property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExpressionAttributeValues() {
        return expressionAttributeValues != null && !(expressionAttributeValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more values that can be substituted in an expression.
     * </p>
     * <p>
     * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that
     * you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
     * </p>
     * <p>
     * <code>Available | Backordered | Discontinued</code>
     * </p>
     * <p>
     * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     * </p>
     * <p>
     * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     * </p>
     * <p>
     * You could then use these values in an expression, such as this:
     * </p>
     * <p>
     * <code>ProductStatus IN (:avail, :back, :disc)</code>
     * </p>
     * <p>
     * For more information on expression attribute values, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpressionAttributeValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more values that can be substituted in an expression.</p>
     *         <p>
     *         Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
     *         suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the
     *         following:
     *         </p>
     *         <p>
     *         <code>Available | Backordered | Discontinued</code>
     *         </p>
     *         <p>
     *         You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     *         </p>
     *         <p>
     *         <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     *         </p>
     *         <p>
     *         You could then use these values in an expression, such as this:
     *         </p>
     *         <p>
     *         <code>ProductStatus IN (:avail, :back, :disc)</code>
     *         </p>
     *         <p>
     *         For more information on expression attribute values, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, AttributeValue> expressionAttributeValues() {
        return expressionAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(selectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(keyConditions());
        hashCode = 31 * hashCode + Objects.hashCode(queryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(conditionalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanIndexForward());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartKey());
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(keyConditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(selectAsString(), other.selectAsString())
                && Objects.equals(attributesToGet(), other.attributesToGet()) && Objects.equals(limit(), other.limit())
                && Objects.equals(consistentRead(), other.consistentRead())
                && Objects.equals(keyConditions(), other.keyConditions()) && Objects.equals(queryFilter(), other.queryFilter())
                && Objects.equals(conditionalOperatorAsString(), other.conditionalOperatorAsString())
                && Objects.equals(scanIndexForward(), other.scanIndexForward())
                && Objects.equals(exclusiveStartKey(), other.exclusiveStartKey())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString())
                && Objects.equals(projectionExpression(), other.projectionExpression())
                && Objects.equals(filterExpression(), other.filterExpression())
                && Objects.equals(keyConditionExpression(), other.keyConditionExpression())
                && Objects.equals(expressionAttributeNames(), other.expressionAttributeNames())
                && Objects.equals(expressionAttributeValues(), other.expressionAttributeValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryRequest").add("TableName", tableName()).add("IndexName", indexName())
                .add("Select", selectAsString()).add("AttributesToGet", attributesToGet()).add("Limit", limit())
                .add("ConsistentRead", consistentRead()).add("KeyConditions", keyConditions()).add("QueryFilter", queryFilter())
                .add("ConditionalOperator", conditionalOperatorAsString()).add("ScanIndexForward", scanIndexForward())
                .add("ExclusiveStartKey", exclusiveStartKey()).add("ReturnConsumedCapacity", returnConsumedCapacityAsString())
                .add("ProjectionExpression", projectionExpression()).add("FilterExpression", filterExpression())
                .add("KeyConditionExpression", keyConditionExpression())
                .add("ExpressionAttributeNames", expressionAttributeNames())
                .add("ExpressionAttributeValues", expressionAttributeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "Select":
            return Optional.ofNullable(clazz.cast(selectAsString()));
        case "AttributesToGet":
            return Optional.ofNullable(clazz.cast(attributesToGet()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "ConsistentRead":
            return Optional.ofNullable(clazz.cast(consistentRead()));
        case "KeyConditions":
            return Optional.ofNullable(clazz.cast(keyConditions()));
        case "QueryFilter":
            return Optional.ofNullable(clazz.cast(queryFilter()));
        case "ConditionalOperator":
            return Optional.ofNullable(clazz.cast(conditionalOperatorAsString()));
        case "ScanIndexForward":
            return Optional.ofNullable(clazz.cast(scanIndexForward()));
        case "ExclusiveStartKey":
            return Optional.ofNullable(clazz.cast(exclusiveStartKey()));
        case "ReturnConsumedCapacity":
            return Optional.ofNullable(clazz.cast(returnConsumedCapacityAsString()));
        case "ProjectionExpression":
            return Optional.ofNullable(clazz.cast(projectionExpression()));
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        case "KeyConditionExpression":
            return Optional.ofNullable(clazz.cast(keyConditionExpression()));
        case "ExpressionAttributeNames":
            return Optional.ofNullable(clazz.cast(expressionAttributeNames()));
        case "ExpressionAttributeValues":
            return Optional.ofNullable(clazz.cast(expressionAttributeValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRequest, T> g) {
        return obj -> g.apply((QueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryRequest> {
        /**
         * <p>
         * The name of the table containing the requested items.
         * </p>
         * 
         * @param tableName
         *        The name of the table containing the requested items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of an index to query. This index can be any local secondary index or global secondary index on the
         * table. Note that if you use the <code>IndexName</code> parameter, you must also provide
         * <code>TableName.</code>
         * </p>
         * 
         * @param indexName
         *        The name of an index to query. This index can be any local secondary index or global secondary index
         *        on the table. Note that if you use the <code>IndexName</code> parameter, you must also provide
         *        <code>TableName.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes,
         * the count of matching items, or in the case of an index, some or all of the attributes projected into the
         * index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you
         * query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item
         * from the parent table. If the index is configured to project all item attributes, then all of the data can be
         * obtained from the local secondary index, and no fetching is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that
         * have been projected into the index. If the index is configured to project all attributes, this return value
         * is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
         * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
         * <code>Select</code>.
         * </p>
         * <p>
         * If you query or scan a local secondary index and request only attributes that are projected into that index,
         * the operation will read only the index and not the table. If any of the requested attributes are not
         * projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table.
         * This extra fetching incurs additional throughput cost and latency.
         * </p>
         * <p>
         * If you query or scan a global secondary index, you can only request attributes that are projected into the
         * index. Global secondary index queries cannot fetch attributes from the parent table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing
         * an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single
         * request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is
         * equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
         * </p>
         * <note>
         * <p>
         * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only
         * be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
         * </p>
         * </note>
         * 
         * @param select
         *        The attributes to be returned in the result. You can retrieve all item attributes, specific item
         *        attributes, the count of matching items, or in the case of an index, some or all of the attributes
         *        projected into the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
         *        you query a local secondary index, then for each matching item in the index, DynamoDB fetches the
         *        entire item from the parent table. If the index is configured to project all item attributes, then all
         *        of the data can be obtained from the local secondary index, and no fetching is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
         *        that have been projected into the index. If the index is configured to project all attributes, this
         *        return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
         *        This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any
         *        value for <code>Select</code>.
         *        </p>
         *        <p>
         *        If you query or scan a local secondary index and request only attributes that are projected into that
         *        index, the operation will read only the index and not the table. If any of the requested attributes
         *        are not projected into the local secondary index, DynamoDB fetches each of these attributes from the
         *        parent table. This extra fetching incurs additional throughput cost and latency.
         *        </p>
         *        <p>
         *        If you query or scan a global secondary index, you can only request attributes that are projected into
         *        the index. Global secondary index queries cannot fetch attributes from the parent table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         *        <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
         *        accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together
         *        in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>.
         *        (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for
         *        <code>Select</code>.)
         *        </p>
         *        <note>
         *        <p>
         *        If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
         *        only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an
         *        error.
         *        </p>
         * @see Select
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Select
         */
        Builder select(String select);

        /**
         * <p>
         * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes,
         * the count of matching items, or in the case of an index, some or all of the attributes projected into the
         * index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If you
         * query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item
         * from the parent table. If the index is configured to project all item attributes, then all of the data can be
         * obtained from the local secondary index, and no fetching is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes that
         * have been projected into the index. If the index is configured to project all attributes, this return value
         * is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>. This
         * return value is equivalent to specifying <code>AttributesToGet</code> without specifying any value for
         * <code>Select</code>.
         * </p>
         * <p>
         * If you query or scan a local secondary index and request only attributes that are projected into that index,
         * the operation will read only the index and not the table. If any of the requested attributes are not
         * projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table.
         * This extra fetching incurs additional throughput cost and latency.
         * </p>
         * <p>
         * If you query or scan a global secondary index, you can only request attributes that are projected into the
         * index. Global secondary index queries cannot fetch attributes from the parent table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         * <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when accessing
         * an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together in a single
         * request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>. (This usage is
         * equivalent to specifying <code>AttributesToGet</code> without any value for <code>Select</code>.)
         * </p>
         * <note>
         * <p>
         * If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can only
         * be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an error.
         * </p>
         * </note>
         * 
         * @param select
         *        The attributes to be returned in the result. You can retrieve all item attributes, specific item
         *        attributes, the count of matching items, or in the case of an index, some or all of the attributes
         *        projected into the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_ATTRIBUTES</code> - Returns all of the item attributes from the specified table or index. If
         *        you query a local secondary index, then for each matching item in the index, DynamoDB fetches the
         *        entire item from the parent table. If the index is configured to project all item attributes, then all
         *        of the data can be obtained from the local secondary index, and no fetching is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_PROJECTED_ATTRIBUTES</code> - Allowed only when querying an index. Retrieves all attributes
         *        that have been projected into the index. If the index is configured to project all attributes, this
         *        return value is equivalent to specifying <code>ALL_ATTRIBUTES</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COUNT</code> - Returns the number of matching items, rather than the matching items themselves.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIC_ATTRIBUTES</code> - Returns only the attributes listed in <code>AttributesToGet</code>.
         *        This return value is equivalent to specifying <code>AttributesToGet</code> without specifying any
         *        value for <code>Select</code>.
         *        </p>
         *        <p>
         *        If you query or scan a local secondary index and request only attributes that are projected into that
         *        index, the operation will read only the index and not the table. If any of the requested attributes
         *        are not projected into the local secondary index, DynamoDB fetches each of these attributes from the
         *        parent table. This extra fetching incurs additional throughput cost and latency.
         *        </p>
         *        <p>
         *        If you query or scan a global secondary index, you can only request attributes that are projected into
         *        the index. Global secondary index queries cannot fetch attributes from the parent table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If neither <code>Select</code> nor <code>AttributesToGet</code> are specified, DynamoDB defaults to
         *        <code>ALL_ATTRIBUTES</code> when accessing a table, and <code>ALL_PROJECTED_ATTRIBUTES</code> when
         *        accessing an index. You cannot use both <code>Select</code> and <code>AttributesToGet</code> together
         *        in a single request, unless the value for <code>Select</code> is <code>SPECIFIC_ATTRIBUTES</code>.
         *        (This usage is equivalent to specifying <code>AttributesToGet</code> without any value for
         *        <code>Select</code>.)
         *        </p>
         *        <note>
         *        <p>
         *        If you use the <code>ProjectionExpression</code> parameter, then the value for <code>Select</code> can
         *        only be <code>SPECIFIC_ATTRIBUTES</code>. Any other value for <code>Select</code> will return an
         *        error.
         *        </p>
         * @see Select
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Select
         */
        Builder select(Select select);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributesToGet
         *        This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         *        >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(Collection<String> attributesToGet);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         * >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributesToGet
         *        This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html"
         *        >AttributesToGet</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(String... attributesToGet);

        /**
         * <p>
         * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes
         * the number of items up to the limit while processing the results, it stops the operation and returns the
         * matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent
         * operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB
         * before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit,
         * and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation to continue the operation. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and Scan</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB
         *        processes the number of items up to the limit while processing the results, it stops the operation and
         *        returns the matching values up to that point, and a key in <code>LastEvaluatedKey</code> to apply in a
         *        subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size
         *        exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching
         *        values up to the limit, and a key in <code>LastEvaluatedKey</code> to apply in a subsequent operation
         *        to continue the operation. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html">Query and
         *        Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly
         * consistent reads; otherwise, the operation uses eventually consistent reads.
         * </p>
         * <p>
         * Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary
         * index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a
         * <code>ValidationException</code>.
         * </p>
         * 
         * @param consistentRead
         *        Determines the read consistency model: If set to <code>true</code>, then the operation uses strongly
         *        consistent reads; otherwise, the operation uses eventually consistent reads.</p>
         *        <p>
         *        Strongly consistent reads are not supported on global secondary indexes. If you query a global
         *        secondary index with <code>ConsistentRead</code> set to <code>true</code>, you will receive a
         *        <code>ValidationException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consistentRead(Boolean consistentRead);

        /**
         * <p>
         * This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see <a
         * href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html"
         * >KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keyConditions
         *        This is a legacy parameter. Use <code>KeyConditionExpression</code> instead. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html"
         *        >KeyConditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyConditions(Map<String, Condition> keyConditions);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html"
         * >QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param queryFilter
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html"
         *        >QueryFilter</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryFilter(Map<String, Condition> queryFilter);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(String conditionalOperator);

        /**
         * <p>
         * This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>FilterExpression</code> instead. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(ConditionalOperator conditionalOperator);

        /**
         * <p>
         * Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in
         * ascending order; if <code>false</code>, the traversal is performed in descending order.
         * </p>
         * <p>
         * Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is
         * Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8
         * bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.
         * </p>
         * <p>
         * If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in which
         * they are stored (by sort key value). This is the default behavior. If <code>ScanIndexForward</code> is
         * <code>false</code>, DynamoDB reads the results in reverse order by sort key value, and then returns the
         * results to the client.
         * </p>
         * 
         * @param scanIndexForward
         *        Specifies the order for index traversal: If <code>true</code> (default), the traversal is performed in
         *        ascending order; if <code>false</code>, the traversal is performed in descending order. </p>
         *        <p>
         *        Items with the same partition key value are stored in sorted order by sort key. If the sort key data
         *        type is Number, the results are stored in numeric order. For type String, the results are stored in
         *        order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.
         *        </p>
         *        <p>
         *        If <code>ScanIndexForward</code> is <code>true</code>, DynamoDB returns the results in the order in
         *        which they are stored (by sort key value). This is the default behavior. If
         *        <code>ScanIndexForward</code> is <code>false</code>, DynamoDB reads the results in reverse order by
         *        sort key value, and then returns the results to the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanIndexForward(Boolean scanIndexForward);

        /**
         * <p>
         * The primary key of the first item that this operation will evaluate. Use the value that was returned for
         * <code>LastEvaluatedKey</code> in the previous operation.
         * </p>
         * <p>
         * The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No set data types are
         * allowed.
         * </p>
         * 
         * @param exclusiveStartKey
         *        The primary key of the first item that this operation will evaluate. Use the value that was returned
         *        for <code>LastEvaluatedKey</code> in the previous operation.</p>
         *        <p>
         *        The data type for <code>ExclusiveStartKey</code> must be String, Number, or Binary. No set data types
         *        are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * A string that identifies one or more attributes to retrieve from the table. These attributes can include
         * scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
         * </p>
         * <p>
         * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes
         * are not found, they will not appear in the result.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param projectionExpression
         *        A string that identifies one or more attributes to retrieve from the table. These attributes can
         *        include scalars, sets, or elements of a JSON document. The attributes in the expression must be
         *        separated by commas.</p>
         *        <p>
         *        If no attribute names are specified, then all attributes will be returned. If any of the requested
         *        attributes are not found, they will not appear in the result.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectionExpression(String projectionExpression);

        /**
         * <p>
         * A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but before
         * the data is returned to you. Items that do not satisfy the <code>FilterExpression</code> criteria are not
         * returned.
         * </p>
         * <p>
         * A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression based on
         * a partition key or a sort key.
         * </p>
         * <note>
         * <p>
         * A <code>FilterExpression</code> is applied after the items have already been read; the process of filtering
         * does not consume any additional read capacity units.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
         * >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param filterExpression
         *        A string that contains conditions that DynamoDB applies after the <code>Query</code> operation, but
         *        before the data is returned to you. Items that do not satisfy the <code>FilterExpression</code>
         *        criteria are not returned.</p>
         *        <p>
         *        A <code>FilterExpression</code> does not allow key attributes. You cannot define a filter expression
         *        based on a partition key or a sort key.
         *        </p>
         *        <note>
         *        <p>
         *        A <code>FilterExpression</code> is applied after the items have already been read; the process of
         *        filtering does not consume any additional read capacity units.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults"
         *        >Filter Expressions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * The condition that specifies the key values for items to be retrieved by the <code>Query</code> action.
         * </p>
         * <p>
         * The condition must perform an equality test on a single partition key value.
         * </p>
         * <p>
         * The condition can optionally perform one of several comparison tests on a single sort key value. This allows
         * <code>Query</code> to retrieve one item with a given partition key value and sort key value, or several items
         * that have the same partition key value but different sort key values.
         * </p>
         * <p>
         * The partition key equality test is required, and must be specified in the following format:
         * </p>
         * <p>
         * <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code>
         * </p>
         * <p>
         * If you also want to provide a condition for the sort key, it must be combined using <code>AND</code> with the
         * condition for the sort key. Following is an example, using the <b>=</b> comparison operator for the sort key:
         * </p>
         * <p>
         * <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code>
         * <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code>
         * </p>
         * <p>
         * Valid comparisons for the sort key condition are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal to
         * <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is less than
         * <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is less
         * than or equal to <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is greater
         * than <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is greater
         * than or equal to <code>:sortkeyval</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code>
         * <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to <code>:sortkeyval1</code>,
         * and less than or equal to <code>:sortkeyval2</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if the
         * sort key value begins with a particular operand. (You cannot use this function with a sort key that is of
         * type Number.) Note that the function name <code>begins_with</code> is case-sensitive.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as <code>:partitionval</code>
         * and <code>:sortval</code> with actual values at runtime.
         * </p>
         * <p>
         * You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the
         * partition key and sort key with placeholder tokens. This option might be necessary if an attribute name
         * conflicts with a DynamoDB reserved word. For example, the following <code>KeyConditionExpression</code>
         * parameter causes an error because <i>Size</i> is a reserved word:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Size = :myval</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name
         * <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#S = :myval</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For a list of reserved words, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * For more information on <code>ExpressionAttributeNames</code> and <code>ExpressionAttributeValues</code>, see
         * <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html">Using
         * Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param keyConditionExpression
         *        The condition that specifies the key values for items to be retrieved by the <code>Query</code>
         *        action.</p>
         *        <p>
         *        The condition must perform an equality test on a single partition key value.
         *        </p>
         *        <p>
         *        The condition can optionally perform one of several comparison tests on a single sort key value. This
         *        allows <code>Query</code> to retrieve one item with a given partition key value and sort key value, or
         *        several items that have the same partition key value but different sort key values.
         *        </p>
         *        <p>
         *        The partition key equality test is required, and must be specified in the following format:
         *        </p>
         *        <p>
         *        <code>partitionKeyName</code> <i>=</i> <code>:partitionkeyval</code>
         *        </p>
         *        <p>
         *        If you also want to provide a condition for the sort key, it must be combined using <code>AND</code>
         *        with the condition for the sort key. Following is an example, using the <b>=</b> comparison operator
         *        for the sort key:
         *        </p>
         *        <p>
         *        <code>partitionKeyName</code> <code>=</code> <code>:partitionkeyval</code> <code>AND</code>
         *        <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code>
         *        </p>
         *        <p>
         *        Valid comparisons for the sort key condition are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>=</code> <code>:sortkeyval</code> - true if the sort key value is equal
         *        to <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>&lt;</code> <code>:sortkeyval</code> - true if the sort key value is
         *        less than <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>&lt;=</code> <code>:sortkeyval</code> - true if the sort key value is
         *        less than or equal to <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>&gt;</code> <code>:sortkeyval</code> - true if the sort key value is
         *        greater than <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>&gt;= </code> <code>:sortkeyval</code> - true if the sort key value is
         *        greater than or equal to <code>:sortkeyval</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sortKeyName</code> <code>BETWEEN</code> <code>:sortkeyval1</code> <code>AND</code>
         *        <code>:sortkeyval2</code> - true if the sort key value is greater than or equal to
         *        <code>:sortkeyval1</code>, and less than or equal to <code>:sortkeyval2</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>begins_with (</code> <code>sortKeyName</code>, <code>:sortkeyval</code> <code>)</code> - true if
         *        the sort key value begins with a particular operand. (You cannot use this function with a sort key
         *        that is of type Number.) Note that the function name <code>begins_with</code> is case-sensitive.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <code>ExpressionAttributeValues</code> parameter to replace tokens such as
         *        <code>:partitionval</code> and <code>:sortval</code> with actual values at runtime.
         *        </p>
         *        <p>
         *        You can optionally use the <code>ExpressionAttributeNames</code> parameter to replace the names of the
         *        partition key and sort key with placeholder tokens. This option might be necessary if an attribute
         *        name conflicts with a DynamoDB reserved word. For example, the following
         *        <code>KeyConditionExpression</code> parameter causes an error because <i>Size</i> is a reserved word:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Size = :myval</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To work around this, define a placeholder (such a <code>#S</code>) to represent the attribute name
         *        <i>Size</i>. <code>KeyConditionExpression</code> then is as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#S = :myval</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For a list of reserved words, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         *        </p>
         *        <p>
         *        For more information on <code>ExpressionAttributeNames</code> and
         *        <code>ExpressionAttributeValues</code>, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html"
         *        >Using Placeholders for Attribute Names and Values</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyConditionExpression(String keyConditionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for
         * using <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To access an attribute whose name conflicts with a DynamoDB reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a placeholder for repeating occurrences of an attribute name in an expression.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent special characters in an attribute name from being misinterpreted in an expression.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
         * following attribute name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Percentile</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression.
         * (For the complete list of reserved words, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>{"#P":"Percentile"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You could then use this substitution in an expression, as in this example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#P = :val</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders
         * for the actual value at runtime.
         * </p>
         * </note>
         * <p>
         * For more information on expression attribute names, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression. The following are some use cases
         *        for using <code>ExpressionAttributeNames</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To access an attribute whose name conflicts with a DynamoDB reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a placeholder for repeating occurrences of an attribute name in an expression.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent special characters in an attribute name from being misinterpreted in an expression.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider
         *        the following attribute name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Percentile</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
         *        expression. (For the complete list of reserved words, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
         *        following for <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>{"#P":"Percentile"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You could then use this substitution in an expression, as in this example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#P = :val</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
         *        placeholders for the actual value at runtime.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on expression attribute names, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Specifying Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);

        /**
         * <p>
         * One or more values that can be substituted in an expression.
         * </p>
         * <p>
         * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose
         * that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
         * </p>
         * <p>
         * <code>Available | Backordered | Discontinued</code>
         * </p>
         * <p>
         * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         * </p>
         * <p>
         * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         * </p>
         * <p>
         * You could then use these values in an expression, such as this:
         * </p>
         * <p>
         * <code>ProductStatus IN (:avail, :back, :disc)</code>
         * </p>
         * <p>
         * For more information on expression attribute values, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeValues
         *        One or more values that can be substituted in an expression.</p>
         *        <p>
         *        Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
         *        suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of
         *        the following:
         *        </p>
         *        <p>
         *        <code>Available | Backordered | Discontinued</code>
         *        </p>
         *        <p>
         *        You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         *        </p>
         *        <p>
         *        <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         *        </p>
         *        <p>
         *        You could then use these values in an expression, such as this:
         *        </p>
         *        <p>
         *        <code>ProductStatus IN (:avail, :back, :disc)</code>
         *        </p>
         *        <p>
         *        For more information on expression attribute values, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private String indexName;

        private String select;

        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private Boolean consistentRead;

        private Map<String, Condition> keyConditions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Condition> queryFilter = DefaultSdkAutoConstructMap.getInstance();

        private String conditionalOperator;

        private Boolean scanIndexForward;

        private Map<String, AttributeValue> exclusiveStartKey = DefaultSdkAutoConstructMap.getInstance();

        private String returnConsumedCapacity;

        private String projectionExpression;

        private String filterExpression;

        private String keyConditionExpression;

        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            super(model);
            tableName(model.tableName);
            indexName(model.indexName);
            select(model.select);
            attributesToGet(model.attributesToGet);
            limit(model.limit);
            consistentRead(model.consistentRead);
            keyConditions(model.keyConditions);
            queryFilter(model.queryFilter);
            conditionalOperator(model.conditionalOperator);
            scanIndexForward(model.scanIndexForward);
            exclusiveStartKey(model.exclusiveStartKey);
            returnConsumedCapacity(model.returnConsumedCapacity);
            projectionExpression(model.projectionExpression);
            filterExpression(model.filterExpression);
            keyConditionExpression(model.keyConditionExpression);
            expressionAttributeNames(model.expressionAttributeNames);
            expressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getSelect() {
            return select;
        }

        @Override
        public final Builder select(String select) {
            this.select = select;
            return this;
        }

        @Override
        public final Builder select(Select select) {
            this.select(select == null ? null : select.toString());
            return this;
        }

        public final void setSelect(String select) {
            this.select = select;
        }

        public final Collection<String> getAttributesToGet() {
            return attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String... attributesToGet) {
            attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getConsistentRead() {
            return consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final Map<String, Condition.Builder> getKeyConditions() {
            return keyConditions != null ? CollectionUtils.mapValues(keyConditions, Condition::toBuilder) : null;
        }

        @Override
        public final Builder keyConditions(Map<String, Condition> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copy(keyConditions);
            return this;
        }

        public final void setKeyConditions(Map<String, Condition.BuilderImpl> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copyFromBuilder(keyConditions);
        }

        public final Map<String, Condition.Builder> getQueryFilter() {
            return queryFilter != null ? CollectionUtils.mapValues(queryFilter, Condition::toBuilder) : null;
        }

        @Override
        public final Builder queryFilter(Map<String, Condition> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copy(queryFilter);
            return this;
        }

        public final void setQueryFilter(Map<String, Condition.BuilderImpl> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copyFromBuilder(queryFilter);
        }

        public final String getConditionalOperator() {
            return conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator == null ? null : conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final Boolean getScanIndexForward() {
            return scanIndexForward;
        }

        @Override
        public final Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public final void setScanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
        }

        public final Map<String, AttributeValue.Builder> getExclusiveStartKey() {
            return exclusiveStartKey != null ? CollectionUtils.mapValues(exclusiveStartKey, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
            return this;
        }

        public final void setExclusiveStartKey(Map<String, AttributeValue.BuilderImpl> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copyFromBuilder(exclusiveStartKey);
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getProjectionExpression() {
            return projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final String getKeyConditionExpression() {
            return keyConditionExpression;
        }

        @Override
        public final Builder keyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
            return this;
        }

        public final void setKeyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return expressionAttributeValues != null ? CollectionUtils.mapValues(expressionAttributeValues,
                    AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
